/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.geolocation;

import com.liferay.portal.search.geolocation.CircleShape;
import com.liferay.portal.search.geolocation.CircleShapeBuilder;
import com.liferay.portal.search.geolocation.Coordinate;
import com.liferay.portal.search.geolocation.DistanceUnit;
import com.liferay.portal.search.geolocation.EnvelopeShape;
import com.liferay.portal.search.geolocation.EnvelopeShapeBuilder;
import com.liferay.portal.search.geolocation.GeoBuilders;
import com.liferay.portal.search.geolocation.GeoDistance;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.geolocation.GeometryCollectionShapeBuilder;
import com.liferay.portal.search.geolocation.LineStringShape;
import com.liferay.portal.search.geolocation.LineStringShapeBuilder;
import com.liferay.portal.search.geolocation.MultiLineStringShapeBuilder;
import com.liferay.portal.search.geolocation.MultiPointShape;
import com.liferay.portal.search.geolocation.MultiPointShapeBuilder;
import com.liferay.portal.search.geolocation.MultiPolygonShape;
import com.liferay.portal.search.geolocation.MultiPolygonShapeBuilder;
import com.liferay.portal.search.geolocation.Orientation;
import com.liferay.portal.search.geolocation.PointShape;
import com.liferay.portal.search.geolocation.PointShapeBuilder;
import com.liferay.portal.search.geolocation.PolygonShape;
import com.liferay.portal.search.geolocation.PolygonShapeBuilder;
import com.liferay.portal.search.internal.geolocation.CircleShapeImpl;
import com.liferay.portal.search.internal.geolocation.CoordinateImpl;
import com.liferay.portal.search.internal.geolocation.EnvelopeShapeImpl;
import com.liferay.portal.search.internal.geolocation.GeoDistanceImpl;
import com.liferay.portal.search.internal.geolocation.GeoLocationPointImpl;
import com.liferay.portal.search.internal.geolocation.GeometryCollectionShapeImpl;
import com.liferay.portal.search.internal.geolocation.LineStringShapeImpl;
import com.liferay.portal.search.internal.geolocation.MultiLineStringShapeImpl;
import com.liferay.portal.search.internal.geolocation.MultiPointShapeImpl;
import com.liferay.portal.search.internal.geolocation.MultiPolygonShapeImpl;
import com.liferay.portal.search.internal.geolocation.PointShapeImpl;
import com.liferay.portal.search.internal.geolocation.PolygonShapeImpl;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(service={GeoBuilders.class})
public class GeoBuildersImpl
implements GeoBuilders {
    public CircleShape circleShape(Coordinate centerCoordinate, GeoDistance radiusGeoDistance) {
        return this.circleShapeBuilder().center(centerCoordinate).radius(radiusGeoDistance).build();
    }

    public CircleShapeBuilder circleShapeBuilder() {
        return new CircleShapeImpl.CircleShapeBuilderImpl();
    }

    public Coordinate coordinate(double x, double y) {
        return new CoordinateImpl(x, y);
    }

    public Coordinate coordinate(double x, double y, double z) {
        return new CoordinateImpl(x, y, z);
    }

    public EnvelopeShape envelopeShape(Coordinate topLeftCoordinate, Coordinate bottomRightCoordinate) {
        return this.envelopeShapeBuilder().topLeft(topLeftCoordinate).bottomRight(bottomRightCoordinate).build();
    }

    public EnvelopeShapeBuilder envelopeShapeBuilder() {
        return new EnvelopeShapeImpl.EnvelopeShapeBuilderImpl();
    }

    public GeoDistance geoDistance(double distance) {
        return new GeoDistanceImpl(distance);
    }

    public GeoDistance geoDistance(double distance, DistanceUnit distanceUnit) {
        return new GeoDistanceImpl(distance, distanceUnit);
    }

    public GeoLocationPoint geoLocationPoint(double latitude, double longitude) {
        return GeoLocationPointImpl.fromLatitudeLongitude(latitude, longitude);
    }

    public GeoLocationPoint geoLocationPoint(long geoHash) {
        return GeoLocationPointImpl.fromGeoHashLong(geoHash);
    }

    public GeoLocationPoint geoLocationPoint(String geoHash) {
        return GeoLocationPointImpl.fromGeoHash(geoHash);
    }

    public GeometryCollectionShapeBuilder geometryCollectionShapeBuilder() {
        return new GeometryCollectionShapeImpl.GeometryCollectionShapeBuilderImpl();
    }

    public LineStringShape lineStringShape(List<Coordinate> coordinates) {
        return this.lineStringShapeBuilder().coordinates(coordinates).build();
    }

    public LineStringShapeBuilder lineStringShapeBuilder() {
        return new LineStringShapeImpl.LineStringShapeBuilderImpl();
    }

    public MultiLineStringShapeBuilder multiLineStringShapeBuilder() {
        return new MultiLineStringShapeImpl.MultiLineStringShapeBuilderImpl();
    }

    public MultiPointShape multiPointShape(List<Coordinate> coordinates) {
        return this.multiPointShapeBuilder().coordinates(coordinates).build();
    }

    public MultiPointShapeBuilder multiPointShapeBuilder() {
        return new MultiPointShapeImpl.MultiPointShapeBuilderImpl();
    }

    public MultiPolygonShape multiPolygonShape(Orientation orientation) {
        return this.multiPolygonShapeBuilder().orientation(orientation).build();
    }

    public MultiPolygonShapeBuilder multiPolygonShapeBuilder() {
        return new MultiPolygonShapeImpl.MultiPolygonShapeBuilderImpl();
    }

    public PointShape pointShape(Coordinate coordinate) {
        return this.pointShapeBuilder().addCoordinate(coordinate).build();
    }

    public PointShapeBuilder pointShapeBuilder() {
        return new PointShapeImpl.PointShapeBuilderImpl();
    }

    public PolygonShape polygonShape(LineStringShape shellLineStringShape, Orientation orientation) {
        return this.polygonShapeBuilder().shell(shellLineStringShape).orientation(orientation).build();
    }

    public PolygonShapeBuilder polygonShapeBuilder() {
        return new PolygonShapeImpl.PolygonShapeBuilderImpl();
    }
}

