/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.geolocation;

import com.liferay.portal.search.geolocation.Coordinate;
import com.liferay.portal.search.geolocation.GeometryCollectionShape;
import com.liferay.portal.search.geolocation.GeometryCollectionShapeBuilder;
import com.liferay.portal.search.geolocation.Shape;
import com.liferay.portal.search.geolocation.ShapeTranslator;
import com.liferay.portal.search.internal.geolocation.BaseShapeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GeometryCollectionShapeImpl
extends BaseShapeImpl
implements GeometryCollectionShape {
    private final List<Shape> _shapes = new ArrayList<Shape>();

    public <T> T accept(ShapeTranslator<T> shapeTranslator) {
        return (T)shapeTranslator.translate((GeometryCollectionShape)this);
    }

    public List<Shape> getShapes() {
        return Collections.unmodifiableList(this._shapes);
    }

    protected GeometryCollectionShapeImpl() {
    }

    protected GeometryCollectionShapeImpl(GeometryCollectionShapeImpl geometryCollectionShapeImpl) {
        this._shapes.addAll(geometryCollectionShapeImpl._shapes);
        this.setCoordinates(geometryCollectionShapeImpl.getCoordinates());
    }

    public static class GeometryCollectionShapeBuilderImpl
    implements GeometryCollectionShapeBuilder {
        private final GeometryCollectionShapeImpl _geometryCollectionShapeImpl = new GeometryCollectionShapeImpl();

        public GeometryCollectionShapeBuilder addCoordinate(Coordinate coordinate) {
            this._geometryCollectionShapeImpl.addCoordinate(coordinate);
            return this;
        }

        public GeometryCollectionShapeBuilder addShape(Shape shape) {
            this._geometryCollectionShapeImpl._shapes.add(shape);
            return this;
        }

        public GeometryCollectionShape build() {
            return new GeometryCollectionShapeImpl(this._geometryCollectionShapeImpl);
        }

        public GeometryCollectionShapeBuilder coordinates(Coordinate ... coordinates) {
            this._geometryCollectionShapeImpl.setCoordinates(coordinates);
            return this;
        }

        public GeometryCollectionShapeBuilder coordinates(List<Coordinate> coordinates) {
            this._geometryCollectionShapeImpl.setCoordinates(coordinates);
            return this;
        }

        public GeometryCollectionShapeBuilder shapes(Shape ... shapes) {
            this._geometryCollectionShapeImpl._shapes.clear();
            Collections.addAll(this._geometryCollectionShapeImpl._shapes, shapes);
            return this;
        }
    }
}

