/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.geolocation;

import com.liferay.portal.search.geolocation.Coordinate;
import com.liferay.portal.search.geolocation.LineStringShape;
import com.liferay.portal.search.geolocation.Orientation;
import com.liferay.portal.search.geolocation.PolygonShape;
import com.liferay.portal.search.geolocation.PolygonShapeBuilder;
import com.liferay.portal.search.geolocation.ShapeTranslator;
import com.liferay.portal.search.internal.geolocation.BaseShapeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PolygonShapeImpl
extends BaseShapeImpl
implements PolygonShape {
    private final List<LineStringShape> _holeLineStringShapes = new ArrayList<LineStringShape>();
    private Orientation _orientation;
    private LineStringShape _shell;

    public <T> T accept(ShapeTranslator<T> shapeTranslator) {
        return (T)shapeTranslator.translate((PolygonShape)this);
    }

    public List<LineStringShape> getHoles() {
        return Collections.unmodifiableList(this._holeLineStringShapes);
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public LineStringShape getShell() {
        return this._shell;
    }

    protected PolygonShapeImpl() {
    }

    protected PolygonShapeImpl(PolygonShapeImpl polygonShapeImpl) {
        this._orientation = polygonShapeImpl._orientation;
        this._shell = polygonShapeImpl._shell;
        this._holeLineStringShapes.addAll(polygonShapeImpl._holeLineStringShapes);
        this.setCoordinates(polygonShapeImpl.getCoordinates());
    }

    public static class PolygonShapeBuilderImpl
    implements PolygonShapeBuilder {
        private final PolygonShapeImpl _polygonShapeImpl = new PolygonShapeImpl();

        public PolygonShapeBuilder addCoordinate(Coordinate coordinate) {
            this._polygonShapeImpl.addCoordinate(coordinate);
            return this;
        }

        public PolygonShapeBuilder addHole(LineStringShape lineStringShape) {
            this._polygonShapeImpl._holeLineStringShapes.add(lineStringShape);
            return this;
        }

        public PolygonShape build() {
            return new PolygonShapeImpl(this._polygonShapeImpl);
        }

        public PolygonShapeBuilder coordinates(Coordinate ... coordinates) {
            this._polygonShapeImpl.setCoordinates(coordinates);
            return this;
        }

        public PolygonShapeBuilder coordinates(List<Coordinate> coordinates) {
            this._polygonShapeImpl.setCoordinates(coordinates);
            return this;
        }

        public PolygonShapeBuilder holes(LineStringShape ... lineStringShapes) {
            this._polygonShapeImpl._holeLineStringShapes.clear();
            Collections.addAll(this._polygonShapeImpl._holeLineStringShapes, lineStringShapes);
            return this;
        }

        public PolygonShapeBuilder orientation(Orientation orientation) {
            this._polygonShapeImpl._orientation = orientation;
            return this;
        }

        public PolygonShapeBuilder shell(LineStringShape shell) {
            this._polygonShapeImpl._shell = shell;
            return this;
        }
    }
}

