/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.hits;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.hits.HitsProcessor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"sort.order=2"}, service={HitsProcessor.class})
public class QueryIndexingHitsProcessor
implements HitsProcessor {
    @Reference
    protected IndexWriterHelper indexWriterHelper;

    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isQueryIndexingEnabled()) {
            return true;
        }
        if (hits.getLength() >= queryConfig.getQueryIndexingThreshold()) {
            this._addDocument(searchContext.getCompanyId(), searchContext.getKeywords(), searchContext.getLocale());
        }
        return true;
    }

    private void _addDocument(long companyId, String keywords, Locale locale) throws SearchException {
        this.indexWriterHelper.indexKeyword(companyId, keywords, 0.0f, "querySuggestion", locale);
    }
}

