/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.BaseIndexerPostProcessor;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry", "indexer.class.name=com.liferay.journal.model.JournalArticle", "indexer.class.name=com.liferay.knowledge.base.model.KBArticle", "indexer.class.name=com.liferay.wiki.model.WikiPage"}, service={IndexerPostProcessor.class})
public class ContentLengthIndexerPostProcessor
extends BaseIndexerPostProcessor {
    @Reference
    private Language _language;

    public void postProcessDocument(Document document, Object object) throws Exception {
        String content = document.get("content");
        if (!Validator.isBlank((String)content)) {
            document.addNumber("contentLength", content.length());
        }
        long groupId = GetterUtil.getLong((String)document.get("groupId"));
        for (Locale locale : this._language.getAvailableLocales(groupId)) {
            String localizedContent = document.get(StringBundler.concat((String[])new String[]{"content", "_", this._language.getLanguageId(locale)}));
            if (Validator.isBlank((String)localizedContent)) continue;
            document.addNumber("contentLength_" + this._language.getLanguageId(locale), localizedContent.length());
        }
    }
}

