/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SearchResultPermissionFilter;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterSearcher;
import com.liferay.portal.kernel.search.hits.HitsProcessorRegistry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.search.indexer.IndexerPermissionPostFilter;
import com.liferay.portal.search.indexer.IndexerQueryBuilder;
import com.liferay.portal.search.indexer.IndexerSearcher;
import com.liferay.portal.search.internal.searcher.helper.IndexSearcherHelper;
import com.liferay.portal.search.spi.model.query.contributor.QueryConfigContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.QueryConfigContributorHelper;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;

public class IndexerSearcherImpl<T extends BaseModel<?>>
implements IndexerSearcher {
    private final HitsProcessorRegistry _hitsProcessorRegistry;
    private final IndexerPermissionPostFilter _indexerPermissionPostFilter;
    private final IndexerQueryBuilder _indexerQueryBuilder;
    private final IndexSearcherHelper _indexSearcherHelper;
    private final Iterable<QueryConfigContributor> _modelQueryConfigContributors;
    private final ModelSearchSettings _modelSearchSettings;
    private final Iterable<QueryConfigContributor> _queryConfigContributors;
    private final SearchResultPermissionFilterFactory _searchResultPermissionFilterFactory;

    public IndexerSearcherImpl(ModelSearchSettings modelSearchSettings, Iterable<QueryConfigContributor> modelQueryConfigContributors, IndexerPermissionPostFilter indexerPermissionPostFilter, IndexerQueryBuilder indexerQueryBuilder, HitsProcessorRegistry hitsProcessorRegistry, IndexSearcherHelper indexSearcherHelper, Iterable<QueryConfigContributor> queryConfigContributors, SearchResultPermissionFilterFactory searchResultPermissionFilterFactory) {
        this._modelSearchSettings = modelSearchSettings;
        this._modelQueryConfigContributors = modelQueryConfigContributors;
        this._indexerPermissionPostFilter = indexerPermissionPostFilter;
        this._indexerQueryBuilder = indexerQueryBuilder;
        this._hitsProcessorRegistry = hitsProcessorRegistry;
        this._indexSearcherHelper = indexSearcherHelper;
        this._queryConfigContributors = queryConfigContributors;
        this._searchResultPermissionFilterFactory = searchResultPermissionFilterFactory;
    }

    public Hits search(SearchContext searchContext) {
        QueryConfigContributorHelper queryConfigContributorHelper = new QueryConfigContributorHelper(){

            public String[] getDefaultSelectedFieldNames() {
                return IndexerSearcherImpl.this._modelSearchSettings.getDefaultSelectedFieldNames();
            }

            public String[] getDefaultSelectedLocalizedFieldNames() {
                return IndexerSearcherImpl.this._modelSearchSettings.getDefaultSelectedLocalizedFieldNames();
            }

            public boolean isSelectAllLocales() {
                return IndexerSearcherImpl.this._modelSearchSettings.isSelectAllLocales();
            }
        };
        this._queryConfigContributors.forEach(queryConfigContributor -> queryConfigContributor.contributeQueryConfigurations(searchContext, queryConfigContributorHelper));
        this._modelQueryConfigContributors.forEach(modelQueryConfigContributor -> modelQueryConfigContributor.contributeQueryConfigurations(searchContext, queryConfigContributorHelper));
        Hits hits = this._search(searchContext);
        this._processHits(searchContext, hits);
        return hits;
    }

    public long searchCount(SearchContext searchContext) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null && this._indexerPermissionPostFilter.isPermissionAware()) {
            Hits hits = this.search(searchContext);
            return hits.getLength();
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setHitsProcessingEnabled(false);
        queryConfig.setScoreEnabled(false);
        queryConfig.setQueryIndexingEnabled(false);
        queryConfig.setQuerySuggestionEnabled(false);
        searchContext.setSearchEngineId(this._modelSearchSettings.getSearchEngineId());
        BooleanQuery fullQuery = this._indexerQueryBuilder.getQuery(searchContext);
        fullQuery.setQueryConfig(queryConfig);
        return this._indexSearcherHelper.searchCount(searchContext, (Query)fullQuery);
    }

    private Hits _doSearch(SearchContext searchContext) {
        searchContext.setSearchEngineId(this._modelSearchSettings.getSearchEngineId());
        BooleanQuery fullQuery = this._indexerQueryBuilder.getQuery(searchContext);
        fullQuery.setQueryConfig(searchContext.getQueryConfig());
        return this._indexSearcherHelper.search(searchContext, (Query)fullQuery);
    }

    private SearchResultPermissionFilter _getSearchResultPermissionFilter(SearchContext searchContext, SearchResultPermissionFilterSearcher searchResultPermissionFilterSearcher) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return null;
        }
        if (searchContext.getUserId() == 0L) {
            searchContext.setUserId(permissionChecker.getUserId());
        }
        return this._searchResultPermissionFilterFactory.create(searchResultPermissionFilterSearcher, permissionChecker);
    }

    private boolean _isUseSearchResultPermissionFilter() {
        return this._indexerPermissionPostFilter.isPermissionAware() && !this._modelSearchSettings.isSearchResultPermissionFilterSuppressed();
    }

    private void _processHits(SearchContext searchContext, Hits hits) {
        try {
            this._hitsProcessorRegistry.process(searchContext, hits);
        }
        catch (SearchException searchException) {
            throw new RuntimeException(searchException);
        }
    }

    private Hits _search(SearchContext searchContext) {
        try {
            SearchResultPermissionFilter searchResultPermissionFilter;
            if (this._isUseSearchResultPermissionFilter() && (searchResultPermissionFilter = this._getSearchResultPermissionFilter(searchContext, this::_doSearch)) != null) {
                return searchResultPermissionFilter.search(searchContext);
            }
            return this._doSearch(searchContext);
        }
        catch (SearchException searchException) {
            throw new RuntimeException(searchException);
        }
    }
}

