/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.search.indexer.IndexerSummaryBuilder;
import com.liferay.portal.search.internal.indexer.IndexerPostProcessorsHolder;
import com.liferay.portal.search.spi.model.result.contributor.ModelSummaryContributor;
import java.util.Locale;

public class IndexerSummaryBuilderImpl
implements IndexerSummaryBuilder {
    private final IndexerPostProcessorsHolder _indexerPostProcessorsHolder;
    private final ModelSummaryContributor _modelSummaryContributor;

    public IndexerSummaryBuilderImpl(ModelSummaryContributor modelSummaryContributor, IndexerPostProcessorsHolder indexerPostProcessorsHolder) {
        this._modelSummaryContributor = modelSummaryContributor;
        this._indexerPostProcessorsHolder = indexerPostProcessorsHolder;
    }

    public Summary getSummary(Document document, String snippet, Locale locale) {
        if (this._modelSummaryContributor == null) {
            return null;
        }
        Summary summary = this._modelSummaryContributor.getSummary(document, locale, snippet);
        this._indexerPostProcessorsHolder.forEach(indexerPostProcessor -> indexerPostProcessor.postProcessSummary(summary, document, locale, snippet));
        return summary;
    }
}

