/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.search.SearchResultPermissionFilterFactory;
import com.liferay.portal.kernel.search.hits.HitsProcessorRegistry;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.search.batch.BatchIndexingHelper;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.index.UpdateDocumentIndexWriter;
import com.liferay.portal.search.indexer.BaseModelDocumentFactory;
import com.liferay.portal.search.indexer.BaseModelRetriever;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.indexer.IndexerPermissionPostFilter;
import com.liferay.portal.search.indexer.IndexerQueryBuilder;
import com.liferay.portal.search.indexer.IndexerSearcher;
import com.liferay.portal.search.indexer.IndexerSummaryBuilder;
import com.liferay.portal.search.indexer.IndexerWriter;
import com.liferay.portal.search.internal.expando.helper.ExpandoQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.DefaultIndexer;
import com.liferay.portal.search.internal.indexer.IndexerDocumentBuilderImpl;
import com.liferay.portal.search.internal.indexer.IndexerPermissionPostFilterImpl;
import com.liferay.portal.search.internal.indexer.IndexerPostProcessorsHolder;
import com.liferay.portal.search.internal.indexer.IndexerQueryBuilderImpl;
import com.liferay.portal.search.internal.indexer.IndexerSearcherImpl;
import com.liferay.portal.search.internal.indexer.IndexerSummaryBuilderImpl;
import com.liferay.portal.search.internal.indexer.IndexerWriterImpl;
import com.liferay.portal.search.internal.indexer.ModelKeywordQueryContributorsHolderImpl;
import com.liferay.portal.search.internal.indexer.helper.AddSearchKeywordsQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.helper.PreFilterContributorHelper;
import com.liferay.portal.search.internal.searcher.helper.IndexSearcherHelper;
import com.liferay.portal.search.permission.SearchPermissionDocumentContributor;
import com.liferay.portal.search.permission.SearchPermissionIndexWriter;
import com.liferay.portal.search.spi.model.query.contributor.QueryConfigContributor;
import com.liferay.portal.search.spi.model.query.contributor.SearchContextContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchConfigurator;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={ModelSearchConfiguratorServiceTrackerCustomizer.class})
public class ModelSearchConfiguratorServiceTrackerCustomizer<T extends BaseModel<?>>
implements ServiceTrackerCustomizer<ModelSearchConfigurator<T>, ModelSearchConfigurator<T>> {
    @Reference
    protected AddSearchKeywordsQueryContributorHelper addSearchKeywordsQueryContributorHelper;
    @Reference
    protected BaseModelDocumentFactory baseModelDocumentFactory;
    @Reference
    protected BaseModelRetriever baseModelRetriever;
    @Reference
    protected BatchIndexingHelper batchIndexingHelper;
    @Reference
    protected ExpandoQueryContributorHelper expandoQueryContributorHelper;
    @Reference
    protected HitsProcessorRegistry hitsProcessorRegistry;
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected IndexSearcherHelper indexSearcherHelper;
    @Reference
    protected IndexStatusManager indexStatusManager;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected PreFilterContributorHelper preFilterContributorHelper;
    @Reference
    protected Props props;
    @Reference
    protected RelatedEntryIndexerRegistry relatedEntryIndexerRegistry;
    @Reference
    protected SearchPermissionDocumentContributor searchPermissionDocumentContributor;
    @Reference
    protected SearchPermissionIndexWriter searchPermissionIndexWriter;
    @Reference
    protected SearchResultPermissionFilterFactory searchResultPermissionFilterFactory;
    @Reference
    protected UpdateDocumentIndexWriter updateDocumentIndexWriter;
    private static final Log _log = LogFactoryUtil.getLog(ModelSearchConfiguratorServiceTrackerCustomizer.class);
    private BundleContext _bundleContext;
    private ServiceTrackerList<DocumentContributor<?>> _documentContributors;
    private ServiceTrackerMap<String, ModelResourcePermission<?>> _modelResourcePermissionServiceTrackerMap;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    private ServiceTrackerList<QueryConfigContributor> _queryConfigContributors;
    private ServiceTrackerList<SearchContextContributor> _searchContextContributors;
    private final Map<String, ServiceRegistrationHolder> _serviceRegistrationHolders = new Hashtable<String, ServiceRegistrationHolder>();
    private ServiceTracker<ModelSearchConfigurator<T>, ModelSearchConfigurator<T>> _serviceTracker;

    public ModelSearchConfigurator<T> addingService(ServiceReference<ModelSearchConfigurator<T>> serviceReference) {
        int serviceRanking = GetterUtil.getInteger((Object)serviceReference.getProperty("service.ranking"));
        ModelSearchConfigurator modelSearchConfigurator = (ModelSearchConfigurator)this._bundleContext.getService(serviceReference);
        ServiceRegistrationHolder serviceRegistrationHolder = this._serviceRegistrationHolders.get(modelSearchConfigurator.getClassName());
        if (serviceRegistrationHolder != null && serviceRegistrationHolder._serviceRanking > serviceRanking) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{ClassUtil.getClassName((Object)serviceRegistrationHolder), " is already registered with a higher ranking of ", serviceRegistrationHolder._serviceRanking, " for: ", modelSearchConfigurator.getClassName()}));
            }
            return modelSearchConfigurator;
        }
        serviceRegistrationHolder = new ServiceRegistrationHolder(modelSearchConfigurator, serviceRanking);
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>(Collections.singletonMap("indexer.class.name", modelSearchConfigurator.getClassName()));
        Indexer<String> defaultIndexer = this._buildIndexer(modelSearchConfigurator, serviceRegistrationHolder, serviceProperties);
        serviceRegistrationHolder.setIndexerServiceRegistration(this._bundleContext.registerService(Indexer.class, defaultIndexer, serviceProperties));
        this._serviceRegistrationHolders.put(modelSearchConfigurator.getClassName(), serviceRegistrationHolder);
        return modelSearchConfigurator;
    }

    public void modifiedService(ServiceReference<ModelSearchConfigurator<T>> serviceReference, ModelSearchConfigurator<T> modelSearchConfigurator) {
        this.removedService(serviceReference, modelSearchConfigurator);
        this.addingService(serviceReference);
    }

    public void removedService(ServiceReference<ModelSearchConfigurator<T>> serviceReference, ModelSearchConfigurator<T> modelSearchConfigurator) {
        ServiceRegistrationHolder serviceRegistrationHolder = this._serviceRegistrationHolders.remove(modelSearchConfigurator.getClassName());
        if (serviceRegistrationHolder != null) {
            serviceRegistrationHolder.close();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._documentContributors = ServiceTrackerListFactory.open((BundleContext)this._bundleContext, DocumentContributor.class, (String)"(!(indexer.class.name=*))");
        this._modelResourcePermissionServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ModelResourcePermission.class, (String)"model.class.name");
        this._queryConfigContributors = ServiceTrackerListFactory.open((BundleContext)this._bundleContext, QueryConfigContributor.class, (String)"(!(indexer.class.name=*))");
        this._searchContextContributors = ServiceTrackerListFactory.open((BundleContext)this._bundleContext, SearchContextContributor.class, (String)"(!(indexer.class.name=*))");
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, ModelSearchConfigurator.class, (ServiceTrackerCustomizer)this);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleContext = null;
        this._serviceTracker.close();
        this._documentContributors.close();
        this._queryConfigContributors.close();
        this._searchContextContributors.close();
        this._serviceRegistrationHolders.forEach((key, serviceRegistrationHolder) -> serviceRegistrationHolder.close());
    }

    private Indexer<?> _buildIndexer(ModelSearchConfigurator<T> modelSearchConfigurator, ServiceRegistrationHolder serviceRegistrationHolder, Dictionary<String, ?> serviceProperties) {
        Iterable modelDocumentContributors = modelSearchConfigurator.getModelDocumentContributors();
        ServiceTrackerList<DocumentContributor<?>> documentContributors = this._documentContributors;
        IndexerPostProcessorsHolder indexerPostProcessorsHolder = new IndexerPostProcessorsHolder();
        IndexerDocumentBuilderImpl indexerDocumentBuilder = new IndexerDocumentBuilderImpl(this.baseModelDocumentFactory, modelDocumentContributors, (Iterable<DocumentContributor<?>>)documentContributors, indexerPostProcessorsHolder, this.searchPermissionDocumentContributor);
        serviceRegistrationHolder.setIndexerDocumentBuilderServiceRegistration((ServiceRegistration<IndexerDocumentBuilder>)this._bundleContext.registerService(IndexerDocumentBuilder.class, (Object)indexerDocumentBuilder, serviceProperties));
        IndexerQueryBuilderImpl indexerQueryBuilderImpl = new IndexerQueryBuilderImpl(this.addSearchKeywordsQueryContributorHelper, this.expandoQueryContributorHelper, this.indexerRegistry, modelSearchConfigurator.getModelSearchSettings(), new ModelKeywordQueryContributorsHolderImpl(modelSearchConfigurator.getKeywordQueryContributors()), modelSearchConfigurator.getSearchContextContributors(), this.preFilterContributorHelper, (Iterable<SearchContextContributor>)this._searchContextContributors, indexerPostProcessorsHolder, this.relatedEntryIndexerRegistry);
        serviceRegistrationHolder.setIndexerQueryBuilderServiceRegistration((ServiceRegistration<IndexerQueryBuilder>)this._bundleContext.registerService(IndexerQueryBuilder.class, indexerQueryBuilderImpl, serviceProperties));
        IndexerPermissionPostFilterImpl indexerPermissionPostFilter = new IndexerPermissionPostFilterImpl(() -> Optional.ofNullable(this._modelResourcePermissionServiceTrackerMap.getService((Object)modelSearchConfigurator.getClassName())), () -> Optional.ofNullable(modelSearchConfigurator.getModelVisibilityContributor()));
        serviceRegistrationHolder.setIndexerPermissionPostFilterServiceRegistration((ServiceRegistration<IndexerPermissionPostFilter>)this._bundleContext.registerService(IndexerPermissionPostFilter.class, (Object)indexerPermissionPostFilter, serviceProperties));
        IndexerSearcherImpl indexerSearcher = new IndexerSearcherImpl(modelSearchConfigurator.getModelSearchSettings(), modelSearchConfigurator.getQueryConfigContributors(), indexerPermissionPostFilter, indexerQueryBuilderImpl, this.hitsProcessorRegistry, this.indexSearcherHelper, (Iterable<QueryConfigContributor>)this._queryConfigContributors, this.searchResultPermissionFilterFactory);
        serviceRegistrationHolder.setIndexerSearcherServiceRegistration((ServiceRegistration<IndexerSearcher>)this._bundleContext.registerService(IndexerSearcher.class, indexerSearcher, serviceProperties));
        IndexerWriterImpl indexerWriter = new IndexerWriterImpl(modelSearchConfigurator.getModelSearchSettings(), this.baseModelRetriever, this.batchIndexingHelper, modelSearchConfigurator.getModelIndexerWriterContributor(), indexerDocumentBuilder, this.searchPermissionIndexWriter, this.updateDocumentIndexWriter, this.indexStatusManager, this.indexWriterHelper, this.props);
        serviceRegistrationHolder.setIndexerWriterServiceRegistration(this._bundleContext.registerService(IndexerWriter.class, indexerWriter, serviceProperties));
        IndexerSummaryBuilderImpl indexerSummaryBuilder = new IndexerSummaryBuilderImpl(modelSearchConfigurator.getModelSummaryBuilder(), indexerPostProcessorsHolder);
        serviceRegistrationHolder.setIndexerSummaryBuilderServiceRegistration((ServiceRegistration<IndexerSummaryBuilder>)this._bundleContext.registerService(IndexerSummaryBuilder.class, (Object)indexerSummaryBuilder, serviceProperties));
        return new DefaultIndexer(modelSearchConfigurator.getModelSearchSettings(), indexerDocumentBuilder, indexerSearcher, indexerWriter, indexerPermissionPostFilter, indexerQueryBuilderImpl, indexerSummaryBuilder, indexerPostProcessorsHolder);
    }

    private class ServiceRegistrationHolder {
        private ServiceRegistration<IndexerDocumentBuilder> _indexerDocumentBuilderServiceRegistration;
        private ServiceRegistration<IndexerPermissionPostFilter> _indexerPermissionPostFilterServiceRegistration;
        private ServiceRegistration<IndexerQueryBuilder> _indexerQueryBuilderServiceRegistration;
        private ServiceRegistration<IndexerSearcher> _indexerSearcherServiceRegistration;
        private ServiceRegistration<Indexer<?>> _indexerServiceRegistration;
        private ServiceRegistration<IndexerSummaryBuilder> _indexerSummaryBuilderServiceRegistration;
        private ServiceRegistration<IndexerWriter<?>> _indexerWriterServiceRegistration;
        private final ModelSearchConfigurator<?> _modelSearchConfigurator;
        private final int _serviceRanking;

        public ServiceRegistrationHolder(ModelSearchConfigurator<?> modelSearchConfigurator, int serviceRanking) {
            this._modelSearchConfigurator = modelSearchConfigurator;
            this._serviceRanking = serviceRanking;
        }

        public void close() {
            this._modelSearchConfigurator.close();
            if (this._indexerDocumentBuilderServiceRegistration != null) {
                this._indexerDocumentBuilderServiceRegistration.unregister();
            }
            if (this._indexerPermissionPostFilterServiceRegistration != null) {
                this._indexerPermissionPostFilterServiceRegistration.unregister();
            }
            if (this._indexerQueryBuilderServiceRegistration != null) {
                this._indexerQueryBuilderServiceRegistration.unregister();
            }
            if (this._indexerSearcherServiceRegistration != null) {
                this._indexerSearcherServiceRegistration.unregister();
            }
            if (this._indexerServiceRegistration != null) {
                this._indexerServiceRegistration.unregister();
            }
            if (this._indexerSummaryBuilderServiceRegistration != null) {
                this._indexerSummaryBuilderServiceRegistration.unregister();
            }
            if (this._indexerWriterServiceRegistration != null) {
                this._indexerWriterServiceRegistration.unregister();
            }
        }

        public void setIndexerDocumentBuilderServiceRegistration(ServiceRegistration<IndexerDocumentBuilder> indexerDocumentBuilderServiceRegistration) {
            this._indexerDocumentBuilderServiceRegistration = indexerDocumentBuilderServiceRegistration;
        }

        public void setIndexerPermissionPostFilterServiceRegistration(ServiceRegistration<IndexerPermissionPostFilter> indexerPermissionPostFilterServiceRegistration) {
            this._indexerPermissionPostFilterServiceRegistration = indexerPermissionPostFilterServiceRegistration;
        }

        public void setIndexerQueryBuilderServiceRegistration(ServiceRegistration<IndexerQueryBuilder> indexerQueryBuilderServiceRegistration) {
            this._indexerQueryBuilderServiceRegistration = indexerQueryBuilderServiceRegistration;
        }

        public void setIndexerSearcherServiceRegistration(ServiceRegistration<IndexerSearcher> indexerSearcherServiceRegistration) {
            this._indexerSearcherServiceRegistration = indexerSearcherServiceRegistration;
        }

        public void setIndexerServiceRegistration(ServiceRegistration<Indexer<?>> indexerServiceRegistration) {
            this._indexerServiceRegistration = indexerServiceRegistration;
        }

        public void setIndexerSummaryBuilderServiceRegistration(ServiceRegistration<IndexerSummaryBuilder> indexerSummaryBuilderServiceRegistration) {
            this._indexerSummaryBuilderServiceRegistration = indexerSummaryBuilderServiceRegistration;
        }

        public void setIndexerWriterServiceRegistration(ServiceRegistration<IndexerWriter<?>> indexerWriterServiceRegistration) {
            this._indexerWriterServiceRegistration = indexerWriterServiceRegistration;
        }
    }
}

