/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.indexer.helper;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.search.internal.indexer.IndexerProvidedClausesUtil;
import com.liferay.portal.search.internal.indexer.ModelPreFilterContributorsHolder;
import com.liferay.portal.search.internal.indexer.ModelSearchSettingsImpl;
import com.liferay.portal.search.internal.indexer.QueryPreFilterContributorsHolder;
import com.liferay.portal.search.internal.indexer.SearchPermissionFilterContributorsHolder;
import com.liferay.portal.search.internal.indexer.helper.PreFilterContributorHelper;
import com.liferay.portal.search.internal.util.SearchStringUtil;
import com.liferay.portal.search.permission.SearchPermissionFilterContributor;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.query.contributor.QueryPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PreFilterContributorHelper.class})
public class PreFilterContributorHelperImpl
implements PreFilterContributorHelper {
    @Reference
    protected ModelPreFilterContributorsHolder modelPreFilterContributorsHolder;
    @Reference
    protected QueryPreFilterContributorsHolder queryPreFilterContributorsHolder;
    @Reference
    protected SearchPermissionChecker searchPermissionChecker;
    @Reference
    protected SearchPermissionFilterContributorsHolder searchPermissionFilterContributorsHolder;

    @Override
    public void contribute(BooleanFilter booleanFilter, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) {
        this._addPreFilters(booleanFilter, searchContext);
        BooleanFilter preFilterBooleanFilter = new BooleanFilter();
        for (Map.Entry<String, Indexer<?>> entry : entryClassNameIndexerMap.entrySet()) {
            String entryClassName = entry.getKey();
            Indexer<?> indexer = entry.getValue();
            preFilterBooleanFilter.add(this._createPreFilterForEntryClassName(entryClassName, indexer, searchContext), BooleanClauseOccur.SHOULD);
        }
        if (preFilterBooleanFilter.hasClauses()) {
            booleanFilter.add((Filter)preFilterBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    @Override
    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._addModelProvidedPreFilters(booleanFilter, modelSearchSettings, searchContext);
    }

    protected Collection<String> getStrings(String string, SearchContext searchContext) {
        return Arrays.asList(SearchStringUtil.splitAndUnquote(Optional.ofNullable((String)((Object)searchContext.getAttribute(string)))));
    }

    private void _addIndexerProvidedPreFilters(BooleanFilter booleanFilter, Indexer<?> indexer, SearchContext searchContext) {
        if (IndexerProvidedClausesUtil.shouldSuppress(searchContext)) {
            return;
        }
        try {
            indexer.postProcessContextBooleanFilter(booleanFilter, searchContext);
            for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
                indexerPostProcessor.postProcessContextBooleanFilter(booleanFilter, searchContext);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _addModelProvidedPreFilters(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        Stream<ModelPreFilterContributor> stream = this.modelPreFilterContributorsHolder.stream(modelSearchSettings.getClassName(), this.getStrings("search.full.query.clause.contributors.excludes", searchContext), this.getStrings("search.full.query.clause.contributors.includes", searchContext), IndexerProvidedClausesUtil.shouldSuppress(searchContext));
        stream.forEach(modelPreFilterContributor -> modelPreFilterContributor.contribute(booleanFilter, modelSearchSettings, searchContext));
    }

    private void _addPermissionFilter(BooleanFilter booleanFilter, String entryClassName, SearchContext searchContext) {
        if (searchContext.getUserId() == 0L) {
            return;
        }
        Optional<String> optional = this._getParentEntryClassNameOptional(entryClassName);
        String permissionedEntryClassName = optional.orElse(entryClassName);
        this.searchPermissionChecker.getPermissionBooleanFilter(searchContext.getCompanyId(), searchContext.getGroupIds(), searchContext.getUserId(), permissionedEntryClassName, booleanFilter, searchContext);
    }

    private void _addPreFilters(BooleanFilter booleanFilter, SearchContext searchContext) {
        Stream<QueryPreFilterContributor> stream = this.queryPreFilterContributorsHolder.stream(this.getStrings("search.full.query.clause.contributors.excludes", searchContext), this.getStrings("search.full.query.clause.contributors.includes", searchContext));
        stream.forEach(queryPreFilterContributor -> queryPreFilterContributor.contribute(booleanFilter, searchContext));
    }

    private Filter _createPreFilterForEntryClassName(String entryClassName, Indexer<?> indexer, SearchContext searchContext) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.addTerm("entryClassName", entryClassName, BooleanClauseOccur.MUST);
        this._addPermissionFilter(booleanFilter, entryClassName, searchContext);
        this._addIndexerProvidedPreFilters(booleanFilter, indexer, searchContext);
        this._addModelProvidedPreFilters(booleanFilter, this._getModelSearchSettings(indexer), searchContext);
        return booleanFilter;
    }

    private ModelSearchSettings _getModelSearchSettings(Indexer<?> indexer) {
        ModelSearchSettingsImpl modelSearchSettingsImpl = new ModelSearchSettingsImpl(indexer.getClassName());
        modelSearchSettingsImpl.setStagingAware(indexer.isStagingAware());
        return modelSearchSettingsImpl;
    }

    private Optional<String> _getParentEntryClassNameOptional(String entryClassName) {
        Stream<SearchPermissionFilterContributor> stream = this.searchPermissionFilterContributorsHolder.getAll();
        List list = stream.collect(Collectors.toList());
        for (SearchPermissionFilterContributor searchPermissionFilterContributor : list) {
            Optional parentEntryClassNameOptional = searchPermissionFilterContributor.getParentEntryClassNameOptional(entryClassName);
            if (parentEntryClassNameOptional == null || !parentEntryClassNameOptional.isPresent()) continue;
            return parentEntryClassNameOptional;
        }
        return Optional.empty();
    }
}

