/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.legacy.searcher;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.groupby.GroupByResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.internal.searcher.SearchResponseImpl;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.SearchResponseBuilder;
import com.liferay.portal.search.searcher.SearchTimeValue;
import com.liferay.portal.search.stats.StatsResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class SearchResponseBuilderImpl
implements SearchResponseBuilder {
    private static final String _QUERY_STRING = "queryString";
    private static final String _SEARCH_CONTEXT_KEY_SEARCH_RESPONSE = "search.response";
    private final SearchContext _searchContext;

    public SearchResponseBuilderImpl(SearchContext searchContext) {
        this._searchContext = searchContext;
    }

    public SearchResponseBuilder addFederatedSearchResponse(SearchResponse searchResponse) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.addFederatedSearchResponse(searchResponse));
        return this;
    }

    public SearchResponseBuilder aggregationResultsMap(Map<String, AggregationResult> aggregationResultsMap) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setAggregationResultsMap(aggregationResultsMap));
        return this;
    }

    public SearchResponse build() {
        return (SearchResponse)this._withSearchResponseGet(Function.identity());
    }

    public SearchResponseBuilder count(long count) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setCount(count));
        return this;
    }

    public SearchResponseBuilder federatedSearchKey(String key) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setFederatedSearchKey(key));
        return this;
    }

    public SearchResponseBuilder groupByResponses(List<GroupByResponse> groupByResponses) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setGroupByResponses(groupByResponses));
        return this;
    }

    public SearchResponseBuilder hits(Hits hits) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setHits(hits));
        return this;
    }

    public SearchResponseBuilder request(SearchRequest searchRequest) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setRequest(searchRequest));
        return this;
    }

    public SearchResponseBuilder requestString(String requestString) {
        this._searchContext.setAttribute(_QUERY_STRING, (Serializable)((Object)requestString));
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setRequestString(requestString));
        return this;
    }

    public SearchResponseBuilder responseString(String responseString) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setResponseString(responseString));
        return this;
    }

    public SearchResponseBuilder searchHits(SearchHits searchHits) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setSearchHits(searchHits));
        return this;
    }

    public SearchResponseBuilder searchTimeValue(SearchTimeValue searchTimeValue) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setSearchTimeValue(searchTimeValue));
        return this;
    }

    public SearchResponseBuilder statsResponseMap(Map<String, StatsResponse> map) {
        this._withSearchResponseImpl(searchResponseImpl -> searchResponseImpl.setStatsResponseMap(map));
        return this;
    }

    protected static <T extends Serializable> T setAttribute(SearchContext searchContext, String key, T value) {
        searchContext.setAttribute(key, value);
        return value;
    }

    private SearchResponseImpl _getSearchResponseImpl(SearchContext searchContext) {
        return Optional.ofNullable((SearchResponseImpl)searchContext.getAttribute(_SEARCH_CONTEXT_KEY_SEARCH_RESPONSE)).orElseGet(() -> SearchResponseBuilderImpl.setAttribute(searchContext, _SEARCH_CONTEXT_KEY_SEARCH_RESPONSE, new SearchResponseImpl(searchContext)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T _withSearchResponseGet(Function<SearchResponse, T> function) {
        SearchContext searchContext = this._searchContext;
        synchronized (searchContext) {
            return function.apply(this._getSearchResponseImpl(this._searchContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _withSearchResponseImpl(Consumer<SearchResponseImpl> consumer) {
        SearchContext searchContext = this._searchContext;
        synchronized (searchContext) {
            consumer.accept(this._getSearchResponseImpl(this._searchContext));
        }
    }
}

