/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.model.uid;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.internal.util.SearchStringUtil;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;

@Component(service={UIDFactory.class})
public class UIDFactoryImpl
implements UIDFactory {
    private static final boolean _ENFORCE_STANDARD_UID = false;
    private static final String _SYSTEM_SETTINGS_UID_PREFIX = "com_liferay_configuration_admin_web_portlet_SystemSettingsPortlet";

    public String getUID(ClassedModel classedModel) {
        return this._getUID(classedModel);
    }

    public String getUID(Document document) {
        return this._getUID(document);
    }

    public String getUID(com.liferay.portal.search.document.Document document) {
        return this._getUID(document);
    }

    public String getUID(String modelClassName, Serializable primaryKeyObject, long ctCollectionId) {
        return this._getUID(modelClassName, primaryKeyObject, ctCollectionId);
    }

    public void setUID(ClassedModel classedModel, Document document) {
        document.addKeyword("uid", this._getUID(classedModel));
    }

    public void setUID(ClassedModel classedModel, DocumentBuilder documentBuilder) {
        documentBuilder.setString("uid", this._getUID(classedModel));
    }

    private long _getCtCollectionId(ClassedModel classedModel) {
        if (classedModel instanceof CTModel) {
            CTModel ctModel = (CTModel)classedModel;
            return ctModel.getCtCollectionId();
        }
        return 0L;
    }

    private String _getUID(ClassedModel classedModel) {
        return this._getUID(classedModel.getModelClassName(), classedModel.getPrimaryKeyObj(), this._getCtCollectionId(classedModel));
    }

    private String _getUID(Document document) {
        return document.getUID();
    }

    private String _getUID(com.liferay.portal.search.document.Document document) {
        return document.getString("uid");
    }

    private String _getUID(String modelClassName, Serializable primaryKeyObject, long ctCollectionId) {
        if (ctCollectionId != 0L) {
            return StringBundler.concat((Object[])new Object[]{modelClassName, "_PORTLET_", primaryKeyObject, "_FIELD_", ctCollectionId});
        }
        return modelClassName + "_PORTLET_" + primaryKeyObject;
    }

    private boolean _isKnownNonstandard(String uid) {
        return uid.startsWith(_SYSTEM_SETTINGS_UID_PREFIX);
    }

    private String _requireEquals(String expected, String actual) {
        if (this._isKnownNonstandard(actual)) {
            return actual;
        }
        return SearchStringUtil.requireEquals(expected, actual);
    }
}

