/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.internal.query.BaseQueryImpl;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.QueryVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BooleanQueryImpl
extends BaseQueryImpl
implements BooleanQuery {
    private static final long serialVersionUID = 1L;
    private Boolean _adjustPureNegative;
    private final List<Query> _filterQueryClauses = new ArrayList<Query>();
    private Integer _minimumShouldMatch;
    private final List<Query> _mustNotQueryClauses = new ArrayList<Query>();
    private final List<Query> _mustQueryClauses = new ArrayList<Query>();
    private final List<Query> _shouldQueryClauses = new ArrayList<Query>();

    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return (T)queryVisitor.visit((BooleanQuery)this);
    }

    public BooleanQuery addFilterQueryClauses(Query ... clauses) {
        if (ArrayUtil.isEmpty((Object[])clauses)) {
            return this;
        }
        Collections.addAll(this._filterQueryClauses, clauses);
        return this;
    }

    public BooleanQuery addMustNotQueryClauses(Query ... clauses) {
        if (ArrayUtil.isEmpty((Object[])clauses)) {
            return this;
        }
        Collections.addAll(this._mustNotQueryClauses, clauses);
        return this;
    }

    public BooleanQuery addMustQueryClauses(Query ... clauses) {
        if (ArrayUtil.isEmpty((Object[])clauses)) {
            return this;
        }
        Collections.addAll(this._mustQueryClauses, clauses);
        return this;
    }

    public BooleanQuery addShouldQueryClauses(Query ... clauses) {
        if (ArrayUtil.isEmpty((Object[])clauses)) {
            return this;
        }
        Collections.addAll(this._shouldQueryClauses, clauses);
        return this;
    }

    public Boolean getAdjustPureNegative() {
        return this._adjustPureNegative;
    }

    public List<Query> getFilterQueryClauses() {
        return Collections.unmodifiableList(this._filterQueryClauses);
    }

    public Integer getMinimumShouldMatch() {
        return this._minimumShouldMatch;
    }

    public List<Query> getMustNotQueryClauses() {
        return Collections.unmodifiableList(this._mustNotQueryClauses);
    }

    public List<Query> getMustQueryClauses() {
        return Collections.unmodifiableList(this._mustQueryClauses);
    }

    public List<Query> getShouldQueryClauses() {
        return Collections.unmodifiableList(this._shouldQueryClauses);
    }

    public boolean hasClauses() {
        return !this._filterQueryClauses.isEmpty() || !this._mustQueryClauses.isEmpty() || !this._mustNotQueryClauses.isEmpty() || !this._shouldQueryClauses.isEmpty();
    }

    public void setAdjustPureNegative(Boolean adjustPureNegative) {
        this._adjustPureNegative = adjustPureNegative;
    }

    public void setMinimumShouldMatch(Integer minimumShouldMatch) {
        this._minimumShouldMatch = minimumShouldMatch;
    }

    public String toString() {
        StringBundler sb = new StringBundler(11);
        sb.append("{className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append(", filterQueryClauses=");
        sb.append(this._filterQueryClauses);
        sb.append(", mustQueryClauses=");
        sb.append(this._mustQueryClauses);
        sb.append(", mustNotQueryClauses=");
        sb.append(this._mustNotQueryClauses);
        sb.append(", shouldQueryClauses=");
        sb.append(this._shouldQueryClauses);
        sb.append("}");
        return sb.toString();
    }
}

