/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.search.internal.query.BaseQueryImpl;
import com.liferay.portal.search.query.MoreLikeThisQuery;
import com.liferay.portal.search.query.QueryVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MoreLikeThisQueryImpl
extends BaseQueryImpl
implements MoreLikeThisQuery {
    private static final long serialVersionUID = 1L;
    private String _analyzer;
    private final Set<MoreLikeThisQuery.DocumentIdentifier> _documentIdentifiers = new HashSet<MoreLikeThisQuery.DocumentIdentifier>();
    private final List<String> _fields = new ArrayList<String>();
    private Boolean _includeInput;
    private final List<String> _likeTexts = new ArrayList<String>();
    private Integer _maxDocFrequency;
    private Integer _maxQueryTerms;
    private Integer _maxWordLength;
    private Integer _minDocFrequency;
    private String _minShouldMatch;
    private Integer _minTermFrequency;
    private Integer _minWordLength;
    private final Set<String> _stopWords = new HashSet<String>();
    private Float _termBoost;
    private String _type;

    public MoreLikeThisQueryImpl(List<String> fields, String ... likeTexts) {
        this._fields.addAll(fields);
        Collections.addAll(this._likeTexts, likeTexts);
    }

    public MoreLikeThisQueryImpl(Set<MoreLikeThisQuery.DocumentIdentifier> documentIdentifiers) {
        this._documentIdentifiers.addAll(documentIdentifiers);
    }

    public MoreLikeThisQueryImpl(String[] fields, String ... likeTexts) {
        Collections.addAll(this._fields, fields);
        Collections.addAll(this._likeTexts, likeTexts);
    }

    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return (T)queryVisitor.visit((MoreLikeThisQuery)this);
    }

    public void addDocumentIdentifier(MoreLikeThisQuery.DocumentIdentifier documentIdentifier) {
        this._documentIdentifiers.add(documentIdentifier);
    }

    public void addDocumentIdentifiers(Collection<MoreLikeThisQuery.DocumentIdentifier> documentIdentifiers) {
        this._documentIdentifiers.addAll(documentIdentifiers);
    }

    public void addDocumentIdentifiers(MoreLikeThisQuery.DocumentIdentifier ... documentIdentifiers) {
        Collections.addAll(this._documentIdentifiers, documentIdentifiers);
    }

    public void addField(String field) {
        this._fields.add(field);
    }

    public void addFields(Collection<String> fields) {
        this._fields.addAll(fields);
    }

    public void addFields(String ... fields) {
        Collections.addAll(this._fields, fields);
    }

    public void addLikeText(String likeText) {
        this._likeTexts.add(likeText);
    }

    public void addLikeTexts(Collection<String> likeTexts) {
        this._likeTexts.addAll(likeTexts);
    }

    public void addLikeTexts(String ... likeTexts) {
        Collections.addAll(this._likeTexts, likeTexts);
    }

    public void addStopWord(String stopWord) {
        this._stopWords.add(stopWord);
    }

    public void addStopWords(Collection<String> stopWords) {
        this._stopWords.addAll(stopWords);
    }

    public void addStopWords(String ... stopWords) {
        Collections.addAll(this._stopWords, stopWords);
    }

    public String getAnalyzer() {
        return this._analyzer;
    }

    public Set<MoreLikeThisQuery.DocumentIdentifier> getDocumentIdentifiers() {
        return Collections.unmodifiableSet(this._documentIdentifiers);
    }

    public List<String> getFields() {
        return Collections.unmodifiableList(this._fields);
    }

    public List<String> getLikeTexts() {
        return Collections.unmodifiableList(this._likeTexts);
    }

    public Integer getMaxDocFrequency() {
        return this._maxDocFrequency;
    }

    public Integer getMaxQueryTerms() {
        return this._maxQueryTerms;
    }

    public Integer getMaxWordLength() {
        return this._maxWordLength;
    }

    public Integer getMinDocFrequency() {
        return this._minDocFrequency;
    }

    public String getMinShouldMatch() {
        return this._minShouldMatch;
    }

    public Integer getMinTermFrequency() {
        return this._minTermFrequency;
    }

    public Integer getMinWordLength() {
        return this._minWordLength;
    }

    public Set<String> getStopWords() {
        return Collections.unmodifiableSet(this._stopWords);
    }

    public Float getTermBoost() {
        return this._termBoost;
    }

    public String getType() {
        return this._type;
    }

    public boolean isDocumentUIDsEmpty() {
        return this._documentIdentifiers.isEmpty();
    }

    public boolean isFieldsEmpty() {
        return this._likeTexts.isEmpty();
    }

    public Boolean isIncludeInput() {
        return this._includeInput;
    }

    public void setAnalyzer(String analyzer) {
        this._analyzer = analyzer;
    }

    public void setIncludeInput(Boolean includeInput) {
        this._includeInput = includeInput;
    }

    public void setMaxDocFrequency(Integer maxDocFrequency) {
        this._maxDocFrequency = maxDocFrequency;
    }

    public void setMaxQueryTerms(Integer maxQueryTerms) {
        this._maxQueryTerms = maxQueryTerms;
    }

    public void setMaxWordLength(Integer maxWordLength) {
        this._maxWordLength = maxWordLength;
    }

    public void setMinDocFrequency(Integer minDocFrequency) {
        this._minDocFrequency = minDocFrequency;
    }

    public void setMinShouldMatch(String minShouldMatch) {
        this._minShouldMatch = minShouldMatch;
    }

    public void setMinTermFrequency(Integer minTermFrequency) {
        this._minTermFrequency = minTermFrequency;
    }

    public void setMinWordLength(Integer minWordLength) {
        this._minWordLength = minWordLength;
    }

    public void setTermBoost(Float termBoost) {
        this._termBoost = termBoost;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String toString() {
        StringBundler sb = new StringBundler(33);
        sb.append("{analyzer=");
        sb.append(this._analyzer);
        sb.append(", className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append(", documentIdentifiers=");
        sb.append(this._documentIdentifiers);
        sb.append(", fields=");
        sb.append(this._fields);
        sb.append(", includeInput=");
        sb.append((Object)this._includeInput);
        sb.append(", likeTexts=");
        sb.append(this._likeTexts);
        sb.append(", maxDocFrequency=");
        sb.append((Object)this._maxDocFrequency);
        sb.append(", maxQueryTerms=");
        sb.append((Object)this._maxQueryTerms);
        sb.append(", maxWordLength=");
        sb.append((Object)this._maxWordLength);
        sb.append(", minDocFrequency=");
        sb.append((Object)this._minDocFrequency);
        sb.append(", minShouldMatch=");
        sb.append(this._minShouldMatch);
        sb.append(", minTermFrequency=");
        sb.append((Object)this._minTermFrequency);
        sb.append(", minWordLength=");
        sb.append((Object)this._minWordLength);
        sb.append(", stopWords=");
        sb.append(this._stopWords);
        sb.append(", termBoost=");
        sb.append((Object)this._termBoost);
        sb.append(", type=");
        sb.append(this._type);
        sb.append("}");
        return sb.toString();
    }

    public static class DocumentIdentifierImpl
    implements MoreLikeThisQuery.DocumentIdentifier {
        private final String _id;
        private final String _index;
        private final String _type;

        public DocumentIdentifierImpl(String index, String id) {
            this._index = index;
            this._id = id;
            this._type = null;
        }

        public DocumentIdentifierImpl(String index, String type, String id) {
            this._index = index;
            this._type = type;
            this._id = id;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MoreLikeThisQuery.DocumentIdentifier documentIdentifier = (MoreLikeThisQuery.DocumentIdentifier)object;
            return Objects.equals(this._index, documentIdentifier.getIndex()) && Objects.equals(this._type, documentIdentifier.getType()) && Objects.equals(this._id, documentIdentifier.getId());
        }

        public String getId() {
            return this._id;
        }

        public String getIndex() {
            return this._index;
        }

        public String getType() {
            return this._type;
        }

        public int hashCode() {
            return Objects.hash(this._index, this._type, this._id);
        }

        public String toString() {
            StringBundler sb = new StringBundler(9);
            sb.append("{className=");
            Class<?> clazz = this.getClass();
            sb.append(clazz.getSimpleName());
            sb.append(", id=");
            sb.append(this._id);
            sb.append(", index=");
            sb.append(this._index);
            sb.append(", type=");
            sb.append(this._type);
            sb.append("}");
            return sb.toString();
        }
    }
}

