/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.search.internal.query.BaseQueryImpl;
import com.liferay.portal.search.query.QueryVisitor;
import com.liferay.portal.search.query.RangeTermQuery;

public class RangeTermQueryImpl
extends BaseQueryImpl
implements RangeTermQuery {
    private static final long serialVersionUID = 1L;
    private final String _field;
    private final boolean _includesLower;
    private final boolean _includesUpper;
    private Object _lowerBound;
    private RangeTermQuery.Operator _lowerBoundOperator;
    private Object _upperBound;
    private RangeTermQuery.Operator _upperBoundOperator;

    public RangeTermQueryImpl(String field, boolean includesLower, boolean includesUpper) {
        this._field = field;
        this._includesLower = includesLower;
        this._includesUpper = includesUpper;
        this._setOperators(includesLower, includesUpper);
    }

    public RangeTermQueryImpl(String field, boolean includesLower, boolean includesUpper, Object lowerBound, Object upperBound) {
        this._field = field;
        this._includesLower = includesLower;
        this._includesUpper = includesUpper;
        this._lowerBound = lowerBound;
        this._upperBound = upperBound;
        this._setOperators(includesLower, includesUpper);
    }

    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return (T)queryVisitor.visit((RangeTermQuery)this);
    }

    public String getField() {
        return this._field;
    }

    public Object getLowerBound() {
        return this._lowerBound;
    }

    public RangeTermQuery.Operator getLowerBoundOperator() {
        return this._lowerBoundOperator;
    }

    public int getSortOrder() {
        return 20;
    }

    public Object getUpperBound() {
        return this._upperBound;
    }

    public RangeTermQuery.Operator getUpperBoundOperator() {
        return this._upperBoundOperator;
    }

    public boolean isIncludesLower() {
        return this._includesLower;
    }

    public boolean isIncludesUpper() {
        return this._includesUpper;
    }

    public void setLowerBound(Object lowerBound) {
        this._lowerBound = lowerBound;
    }

    public void setUpperBound(Object upperBound) {
        this._upperBound = upperBound;
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{(", this._lowerBound, this._lowerBoundOperator, this._field, this._upperBoundOperator, this._upperBound, "), ", super.toString(), "}"});
    }

    private void _setOperators(boolean includesLower, boolean includesUpper) {
        this._lowerBoundOperator = includesLower ? RangeTermQuery.Operator.GTE : RangeTermQuery.Operator.GT;
        this._upperBoundOperator = includesUpper ? RangeTermQuery.Operator.LTE : RangeTermQuery.Operator.LT;
    }
}

