/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.search.internal.query.BaseQueryImpl;
import com.liferay.portal.search.query.Operator;
import com.liferay.portal.search.query.QueryVisitor;
import com.liferay.portal.search.query.SimpleStringQuery;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleStringQueryImpl
extends BaseQueryImpl
implements SimpleStringQuery {
    private static final long serialVersionUID = 1L;
    private String _analyzer;
    private Boolean _analyzeWildcard;
    private Boolean _autoGenerateSynonymsPhraseQuery;
    private Operator _defaultOperator;
    private final Map<String, Float> _fieldBoostMap = new HashMap<String, Float>();
    private Integer _fuzzyMaxExpansions;
    private Integer _fuzzyPrefixLength;
    private Boolean _fuzzyTranspositions;
    private Boolean _lenient;
    private final String _query;
    private String _quoteFieldSuffix;

    public SimpleStringQueryImpl(String query) {
        this._query = query;
    }

    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return (T)queryVisitor.visit((SimpleStringQuery)this);
    }

    public void addField(String field, float boost) {
        this._fieldBoostMap.put(field, Float.valueOf(boost));
    }

    public void addFields(String ... fields) {
        for (String field : fields) {
            this._fieldBoostMap.put(field, null);
        }
    }

    public String getAnalyzer() {
        return this._analyzer;
    }

    public Boolean getAnalyzeWildcard() {
        return this._analyzeWildcard;
    }

    public Boolean getAutoGenerateSynonymsPhraseQuery() {
        return this._autoGenerateSynonymsPhraseQuery;
    }

    public Operator getDefaultOperator() {
        return this._defaultOperator;
    }

    public Map<String, Float> getFieldBoostMap() {
        return Collections.unmodifiableMap(this._fieldBoostMap);
    }

    public Integer getFuzzyMaxExpansions() {
        return this._fuzzyMaxExpansions;
    }

    public Integer getFuzzyPrefixLength() {
        return this._fuzzyPrefixLength;
    }

    public Boolean getFuzzyTranspositions() {
        return this._fuzzyTranspositions;
    }

    public Boolean getLenient() {
        return this._lenient;
    }

    public String getQuery() {
        return this._query;
    }

    public String getQuoteFieldSuffix() {
        return this._quoteFieldSuffix;
    }

    public void setAnalyzer(String analyzer) {
        this._analyzer = analyzer;
    }

    public void setAnalyzeWildcard(Boolean analyzeWildcard) {
        this._analyzeWildcard = analyzeWildcard;
    }

    public void setAutoGenerateSynonymsPhraseQuery(Boolean autoGenerateSynonymsPhraseQuery) {
        this._autoGenerateSynonymsPhraseQuery = autoGenerateSynonymsPhraseQuery;
    }

    public void setDefaultOperator(Operator defaultOperator) {
        this._defaultOperator = defaultOperator;
    }

    public void setFuzzyMaxExpansions(Integer fuzzyMaxExpansions) {
        this._fuzzyMaxExpansions = fuzzyMaxExpansions;
    }

    public void setFuzzyPrefixLength(Integer fuzzyPrefixLength) {
        this._fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setFuzzyTranspositions(Boolean fuzzyTranspositions) {
        this._fuzzyTranspositions = fuzzyTranspositions;
    }

    public void setLenient(Boolean lenient) {
        this._lenient = lenient;
    }

    public void setQuoteFieldSuffix(String quoteFieldSuffix) {
        this._quoteFieldSuffix = quoteFieldSuffix;
    }

    public String toString() {
        StringBundler sb = new StringBundler(5);
        sb.append("{className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append(", query=");
        sb.append(this._query);
        sb.append("}");
        return sb.toString();
    }
}

