/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.field;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import com.liferay.portal.search.internal.query.field.FullTextQueryBuilder;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.field.FieldQueryBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(property={"exact.match.boost=2.0", "proximity.slop=50"}, service={DescriptionFieldQueryBuilder.class})
public class DescriptionFieldQueryBuilder
implements FieldQueryBuilder {
    @Reference
    protected KeywordTokenizer keywordTokenizer;
    @Reference
    protected Queries queries;
    private volatile float _exactMatchBoost = 2.0f;
    private volatile int _proximitySlop = 50;

    public Query build(String field, String keywords) {
        FullTextQueryBuilder fullTextQueryBuilder = new FullTextQueryBuilder(this.keywordTokenizer, this.queries);
        fullTextQueryBuilder.setExactMatchBoost(this._exactMatchBoost);
        fullTextQueryBuilder.setProximitySlop(this._proximitySlop);
        return fullTextQueryBuilder.build(field, keywords);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._exactMatchBoost = GetterUtil.getFloat((Object)properties.get("exact.match.boost"), (float)this._exactMatchBoost);
        this._proximitySlop = GetterUtil.getInteger((Object)properties.get("proximity.slop"), (int)this._proximitySlop);
    }
}

