/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.field;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.internal.query.field.DescriptionFieldQueryBuilder;
import com.liferay.portal.search.internal.query.field.SubstringFieldQueryBuilder;
import com.liferay.portal.search.internal.query.field.TitleFieldQueryBuilder;
import com.liferay.portal.search.query.field.FieldQueryBuilder;
import com.liferay.portal.search.query.field.FieldQueryBuilderFactory;
import com.liferay.portal.search.query.field.QueryPreProcessConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(property={"description.fields=content|description", "title.fields=name|title"}, service={FieldQueryBuilderFactory.class})
public class FieldQueryBuilderFactoryImpl
implements FieldQueryBuilderFactory {
    @Reference
    protected DescriptionFieldQueryBuilder descriptionFieldQueryBuilder;
    @Reference
    protected QueryPreProcessConfiguration queryPreProcessConfiguration;
    @Reference
    protected SubstringFieldQueryBuilder substringFieldQueryBuilder;
    @Reference
    protected TitleFieldQueryBuilder titleFieldQueryBuilder;
    private volatile Collection<String> _descriptionFieldNames = Arrays.asList("content", "description");
    private volatile Collection<String> _titleFieldNames = new HashSet<String>(Arrays.asList("name", "title"));

    public FieldQueryBuilder getQueryBuilder(String fieldName) {
        if (this.queryPreProcessConfiguration.isSubstringSearchAlways(fieldName)) {
            return this.substringFieldQueryBuilder;
        }
        for (String descriptionFieldName : this._descriptionFieldNames) {
            if (!fieldName.startsWith(descriptionFieldName)) continue;
            return this.descriptionFieldQueryBuilder;
        }
        for (String titleFieldName : this._titleFieldNames) {
            if (!fieldName.startsWith(titleFieldName)) continue;
            return this.titleFieldQueryBuilder;
        }
        return null;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._descriptionFieldNames = this._getFields(properties, "description.fields");
        this._titleFieldNames = this._getFields(properties, "title.fields");
    }

    private Collection<String> _getFields(Map<String, Object> properties, String key) {
        String[] values = StringUtil.split((String)GetterUtil.getString((Object)properties.get(key)), (char)'|');
        return new HashSet<String>(Arrays.asList(values));
    }
}

