/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.field;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import com.liferay.portal.search.internal.query.field.PhraseQueryBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import java.util.ArrayList;
import java.util.List;

public class FullTextQueryBuilder {
    private boolean _autocomplete;
    private float _exactMatchBoost;
    private final KeywordTokenizer _keywordTokenizer;
    private Integer _maxExpansions;
    private Integer _proximitySlop;
    private final Queries _queries;

    public FullTextQueryBuilder(KeywordTokenizer keywordTokenizer, Queries queries) {
        this._keywordTokenizer = keywordTokenizer;
        this._queries = queries;
    }

    public Query build(String field, String keywords) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        List tokens = this._keywordTokenizer.tokenize(keywords);
        ArrayList<String> phrases = new ArrayList<String>(tokens.size());
        ArrayList<String> words = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            if (StringUtil.startsWith((String)token, (char)'\"')) {
                phrases.add(StringUtil.unquote((String)token));
                continue;
            }
            words.add(token);
        }
        for (String phrase : phrases) {
            booleanQuery.addMustQueryClauses(new Query[]{this._createPhraseQuery(field, phrase)});
        }
        if (!words.isEmpty()) {
            this._addSentenceQueries(field, StringUtil.merge(words, (String)" "), booleanQuery);
        }
        booleanQuery.addShouldQueryClauses(new Query[]{this._createExactMatchQuery(field, keywords)});
        return booleanQuery;
    }

    public void setAutocomplete(boolean autocomplete) {
        this._autocomplete = autocomplete;
    }

    public void setExactMatchBoost(float exactMatchBoost) {
        this._exactMatchBoost = exactMatchBoost;
    }

    public void setMaxExpansions(int maxExpansions) {
        this._maxExpansions = maxExpansions;
    }

    public void setProximitySlop(int proximitySlop) {
        this._proximitySlop = proximitySlop;
    }

    private void _addSentenceQueries(String field, String sentence, BooleanQuery booleanQuery) {
        booleanQuery.addMustQueryClauses(new Query[]{this._createMandatoryQuery(field, sentence)});
        if (this._proximitySlop != null) {
            booleanQuery.addShouldQueryClauses(new Query[]{this._createProximityQuery(field, sentence)});
        }
    }

    private Query _createAutocompleteQuery(String field, String value) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder(this._queries);
        builder.setMaxExpansions(this._maxExpansions);
        builder.setPrefix(true);
        return builder.build(field, value);
    }

    private Query _createExactMatchQuery(String field, String keywords) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder(this._queries);
        builder.setBoost(this._exactMatchBoost);
        return builder.build(field, keywords);
    }

    private Query _createMandatoryQuery(String field, String sentence) {
        Query matchQuery = this._createMatchQuery(field, sentence);
        if (!this._autocomplete) {
            return matchQuery;
        }
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        booleanQuery.addShouldQueryClauses(new Query[]{matchQuery});
        booleanQuery.addShouldQueryClauses(new Query[]{this._createAutocompleteQuery(field, sentence)});
        return booleanQuery;
    }

    private Query _createMatchQuery(String field, String value) {
        return this._queries.match(field, (Object)value);
    }

    private Query _createPhraseQuery(String field, String phrase) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder(this._queries);
        builder.setTrailingStarAware(true);
        return builder.build(field, phrase);
    }

    private Query _createProximityQuery(String field, String value) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder(this._queries);
        builder.setSlop(this._proximitySlop);
        return builder.build(field, value);
    }
}

