/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.query.field;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import com.liferay.portal.search.configuration.TitleFieldQueryBuilderConfiguration;
import com.liferay.portal.search.internal.query.field.FullTextQueryBuilder;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.field.FieldQueryBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.TitleFieldQueryBuilderConfiguration"}, service={TitleFieldQueryBuilder.class})
public class TitleFieldQueryBuilder
implements FieldQueryBuilder {
    @Reference
    protected KeywordTokenizer keywordTokenizer;
    @Reference
    protected Queries queries;
    private volatile float _exactMatchBoost = 2.0f;
    private volatile int _maxExpansions = 300;

    public Query build(String field, String keywords) {
        FullTextQueryBuilder fullTextQueryBuilder = new FullTextQueryBuilder(this.keywordTokenizer, this.queries);
        fullTextQueryBuilder.setAutocomplete(true);
        fullTextQueryBuilder.setExactMatchBoost(this._exactMatchBoost);
        fullTextQueryBuilder.setMaxExpansions(this._maxExpansions);
        return fullTextQueryBuilder.build(field, keywords);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        TitleFieldQueryBuilderConfiguration titleFieldQueryConfiguration = (TitleFieldQueryBuilderConfiguration)ConfigurableUtil.createConfigurable(TitleFieldQueryBuilderConfiguration.class, properties);
        this._exactMatchBoost = titleFieldQueryConfiguration.exactMatchBoost();
        this._maxExpansions = titleFieldQueryConfiguration.maxExpansions();
    }
}

