/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.reindexer;

import com.liferay.portal.search.internal.reindexer.BulkReindexersHolder;
import com.liferay.portal.search.spi.reindexer.BulkReindexer;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={BulkReindexersHolder.class})
public class BulkReindexersHolderImpl
implements BulkReindexersHolder {
    private final Map<String, BulkReindexer> _map = new HashMap<String, BulkReindexer>();

    @Override
    public BulkReindexer getBulkReindexer(String className) {
        return this._get(className);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, service=BulkReindexer.class)
    protected void addBulkReindexer(BulkReindexer bulkReindexer, Map<?, ?> properties) {
        Object object = properties.get("indexer.class.name");
        if (object != null) {
            this._put(object.toString(), bulkReindexer);
        }
    }

    protected void removeBulkReindexer(BulkReindexer bulkReindexer, Map<?, ?> properties) {
        Object object = properties.get("indexer.class.name");
        if (object != null) {
            this._remove(object.toString());
        }
    }

    private synchronized BulkReindexer _get(String className) {
        return this._map.get(className);
    }

    private synchronized void _put(String className, BulkReindexer bulkReindexer) {
        this._map.put(className, bulkReindexer);
    }

    private synchronized void _remove(String className) {
        this._map.remove(className);
    }
}

