/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.reindexer;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.configuration.ReindexerConfiguration;
import com.liferay.portal.search.internal.reindexer.BulkReindexersHolder;
import com.liferay.portal.search.internal.reindexer.Reindex;
import com.liferay.portal.search.internal.reindexer.ReindexRequestsHolder;
import com.liferay.portal.search.reindexer.Reindexer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.configuration.ReindexerConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={Reindexer.class})
public class ReindexerImpl
implements Reindexer {
    @Reference
    protected BulkReindexersHolder bulkReindexersHolder;
    @Reference
    protected IndexerRegistry indexerRegistry;
    private static final ThreadFactory _threadFactory = Executors.defaultThreadFactory();
    private volatile ExecutorService _executorService;
    private volatile ReindexerConfiguration _reindexerConfiguration;
    private volatile ReindexRequestsHolder _reindexRequestsHolder;

    public void reindex(long companyId, String className, long ... classPKs) {
        Reindex reindex = this._getReindex(companyId);
        reindex.reindex(className, classPKs);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._reindexerConfiguration = (ReindexerConfiguration)ConfigurableUtil.createConfigurable(ReindexerConfiguration.class, properties);
        this._executorService = Executors.newSingleThreadExecutor(this::_getThread);
        this._reindexRequestsHolder = new ReindexRequestsHolder();
    }

    @Deactivate
    protected void deactivate() {
        this._executorService.shutdown();
        this._executorService = null;
        this._reindexRequestsHolder = null;
    }

    private Reindex _getReindex(long companyId) {
        Reindex reindex = new Reindex(this.indexerRegistry, this.bulkReindexersHolder, this._executorService, this._reindexRequestsHolder);
        reindex.setCompanyId(companyId);
        reindex.setNonbulkIndexing(Boolean.valueOf(this._reindexerConfiguration.nonbulkIndexingOverride()));
        reindex.setSynchronousExecution(GetterUtil.getBoolean((String)this._reindexerConfiguration.synchronousExecutionOverride(), (boolean)ProxyModeThreadLocal.isForceSync()));
        return reindex;
    }

    private Thread _getThread(Runnable runnable) {
        Thread thread = _threadFactory.newThread(runnable);
        thread.setDaemon(true);
        thread.setName(this + "-" + thread.getName());
        return thread;
    }
}

