/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.searcher;

import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcher;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.asset.SearchableAssetClassNamesProvider;
import com.liferay.portal.search.internal.expando.helper.ExpandoQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.helper.AddSearchKeywordsQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.helper.PostProcessSearchQueryContributorHelper;
import com.liferay.portal.search.internal.indexer.helper.PreFilterContributorHelper;
import com.liferay.portal.search.internal.searcher.helper.IndexSearcherHelper;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequest;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FacetedSearcherImpl
extends BaseSearcher
implements FacetedSearcher {
    private final AddSearchKeywordsQueryContributorHelper _addSearchKeywordsQueryContributorHelper;
    private final ExpandoQueryContributorHelper _expandoQueryContributorHelper;
    private final IndexerRegistry _indexerRegistry;
    private final IndexSearcherHelper _indexSearcherHelper;
    private final PostProcessSearchQueryContributorHelper _postProcessSearchQueryContributorHelper;
    private final PreFilterContributorHelper _preFilterContributorHelper;
    private final SearchableAssetClassNamesProvider _searchableAssetClassNamesProvider;
    private final SearchRequestBuilderFactory _searchRequestBuilderFactory;

    public FacetedSearcherImpl(AddSearchKeywordsQueryContributorHelper addSearchKeywordsQueryContributorHelper, ExpandoQueryContributorHelper expandoQueryContributorHelper, IndexerRegistry indexerRegistry, IndexSearcherHelper indexSearcherHelper, PostProcessSearchQueryContributorHelper postProcessSearchQueryContributorHelper, PreFilterContributorHelper preFilterContributorHelper, SearchableAssetClassNamesProvider searchableAssetClassNamesProvider, SearchRequestBuilderFactory searchRequestBuilderFactory) {
        this._addSearchKeywordsQueryContributorHelper = addSearchKeywordsQueryContributorHelper;
        this._expandoQueryContributorHelper = expandoQueryContributorHelper;
        this._indexerRegistry = indexerRegistry;
        this._indexSearcherHelper = indexSearcherHelper;
        this._postProcessSearchQueryContributorHelper = postProcessSearchQueryContributorHelper;
        this._preFilterContributorHelper = preFilterContributorHelper;
        this._searchableAssetClassNamesProvider = searchableAssetClassNamesProvider;
        this._searchRequestBuilderFactory = searchRequestBuilderFactory;
    }

    protected BooleanQuery createFullQuery(BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        BooleanClause[] booleanClauses;
        BooleanQueryImpl searchQuery = new BooleanQueryImpl();
        Map<String, Indexer<?>> entryClassNameIndexerMap = this._getEntryClassNameIndexerMap(this._getEntryClassNames(this._getSearchRequest(searchContext), searchContext.getCompanyId()), searchContext.getSearchEngineId());
        this._addSearchKeywords((BooleanQuery)searchQuery, entryClassNameIndexerMap.keySet(), searchContext);
        this._postProcessSearchQuery((BooleanQuery)searchQuery, fullQueryBooleanFilter, entryClassNameIndexerMap.values(), searchContext);
        this._addPreFilters(fullQueryBooleanFilter, entryClassNameIndexerMap, searchContext);
        BooleanQueryImpl fullQuery = new BooleanQueryImpl();
        if (fullQueryBooleanFilter.hasClauses()) {
            fullQuery.setPreBooleanFilter(fullQueryBooleanFilter);
        }
        if (searchQuery.hasClauses()) {
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
        if ((booleanClauses = searchContext.getBooleanClauses()) != null) {
            for (BooleanClause booleanClause : booleanClauses) {
                fullQuery.add((Query)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
            }
        }
        this._postProcessFullQuery(entryClassNameIndexerMap, (BooleanQuery)fullQuery, searchContext);
        return fullQuery;
    }

    protected Hits doSearch(SearchContext searchContext) throws SearchException {
        String keywords = StringUtil.trim((String)searchContext.getKeywords());
        if (Validator.isBlank((String)keywords) && !GetterUtil.getBoolean((Object)searchContext.getAttribute("search.empty.search"))) {
            return new HitsImpl();
        }
        try {
            searchContext.setSearchEngineId(this.getSearchEngineId());
            BooleanFilter booleanFilter = new BooleanFilter();
            booleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
            BooleanQuery query = this.createFullQuery(booleanFilter, searchContext);
            query.setQueryConfig(searchContext.getQueryConfig());
            return this._indexSearcherHelper.search(searchContext, (Query)query);
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        List<String> entryClassNames = this._getEntryClassNames(this._getSearchRequest(searchContext), searchContext.getCompanyId());
        if (ListUtil.isEmpty(entryClassNames)) {
            return super.isFilterSearch();
        }
        for (String entryClassName : entryClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer(entryClassName);
            if (indexer == null || !indexer.isFilterSearch()) continue;
            return true;
        }
        return super.isFilterSearch();
    }

    private void _addPreFilters(BooleanFilter booleanFilter, Map<String, Indexer<?>> entryClassNameIndexerMap, SearchContext searchContext) {
        this._preFilterContributorHelper.contribute(booleanFilter, entryClassNameIndexerMap, searchContext);
    }

    private void _addSearchExpando(BooleanQuery booleanQuery, Collection<String> searchClassNames, SearchContext searchContext) {
        this._expandoQueryContributorHelper.contribute(StringUtil.trim((String)searchContext.getKeywords()), booleanQuery, searchClassNames, searchContext);
    }

    private void _addSearchKeywords(BooleanQuery booleanQuery, Collection<String> searchClassNames, SearchContext searchContext) {
        this._addSearchKeywordsQueryContributorHelper.contribute(booleanQuery, searchContext);
        this._addSearchExpando(booleanQuery, searchClassNames, searchContext);
    }

    private Map<String, Indexer<?>> _getEntryClassNameIndexerMap(List<String> entryClassNames, String searchEngineId) {
        LinkedHashMap entryClassNameIndexerMap = new LinkedHashMap();
        for (String entryClassName : entryClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer(entryClassName);
            if (indexer == null || !searchEngineId.equals(indexer.getSearchEngineId())) continue;
            entryClassNameIndexerMap.put(entryClassName, indexer);
        }
        return entryClassNameIndexerMap;
    }

    private List<String> _getEntryClassNames(SearchRequest searchRequest, long companyId) {
        List entryClassNames = searchRequest.getEntryClassNames();
        if (!ListUtil.isEmpty((List)entryClassNames)) {
            return entryClassNames;
        }
        List modelIndexerClassNames = searchRequest.getModelIndexerClassNames();
        if (!ListUtil.isEmpty((List)modelIndexerClassNames)) {
            return modelIndexerClassNames;
        }
        return ListUtil.fromArray((Object[])this._searchableAssetClassNamesProvider.getClassNames(companyId));
    }

    private SearchRequest _getSearchRequest(SearchContext searchContext) {
        return this._searchRequestBuilderFactory.builder(searchContext).build();
    }

    private void _postProcessFullQuery(Map<String, Indexer<?>> entryClassNameIndexerMap, BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        for (Indexer<?> indexer : entryClassNameIndexerMap.values()) {
            for (IndexerPostProcessor indexerPostProcessor : indexer.getIndexerPostProcessors()) {
                indexerPostProcessor.postProcessFullQuery(fullQuery, searchContext);
            }
        }
    }

    private void _postProcessSearchQuery(BooleanQuery booleanQuery, BooleanFilter booleanFilter, Collection<Indexer<?>> indexers, SearchContext searchContext) throws Exception {
        this._postProcessSearchQueryContributorHelper.contribute(booleanQuery, booleanFilter, indexers, searchContext);
    }
}

