/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.searcher;

import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.groupby.GroupByRequest;
import com.liferay.portal.search.highlight.Highlight;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.stats.StatsRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SearchRequestImpl
implements SearchRequest,
Serializable {
    private final Map<String, Aggregation> _aggregationsMap = new LinkedHashMap<String, Aggregation>();
    private boolean _basicFacetSelection;
    private final List<ComplexQueryPart> _complexQueryParts = new ArrayList<ComplexQueryPart>();
    private String _connectionId;
    private boolean _emptySearchEnabled;
    private final List<String> _excludeContributors = new ArrayList<String>();
    private boolean _explain;
    private String _federatedSearchKey;
    private final Map<String, SearchRequest> _federatedSearchRequestsMap = new LinkedHashMap<String, SearchRequest>();
    private Boolean _fetchSource;
    private String[] _fetchSourceExcludes;
    private String[] _fetchSourceIncludes;
    private Integer _from;
    private final List<GroupByRequest> _groupByRequests = new ArrayList<GroupByRequest>();
    private Highlight _highlight;
    private final List<String> _includeContributors = new ArrayList<String>();
    private boolean _includeResponseString;
    private final List<String> _modelIndexerClassNames = new ArrayList<String>();
    private String _paginationStartParameterName;
    private final Map<String, PipelineAggregation> _pipelineAggregationsMap = new LinkedHashMap<String, PipelineAggregation>();
    private final List<ComplexQueryPart> _postFilterComplexQueryParts = new ArrayList<ComplexQueryPart>();
    private Query _postFilterQuery;
    private Query _query;
    private Query _rescoreQuery;
    private List<Rescore> _rescores = new ArrayList<Rescore>();
    private final SearchContext _searchContext;
    private Integer _size;
    private final List<Sort> _sorts = new ArrayList<Sort>();
    private final List<StatsRequest> _statsRequests = new ArrayList<StatsRequest>();

    public static boolean isBasicFacetSelection(SearchContext searchContext) {
        return GetterUtil.getBoolean((Object)searchContext.getAttribute("search.basic.facet.selection"));
    }

    public SearchRequestImpl(SearchContext searchContext) {
        this._searchContext = searchContext;
    }

    public SearchRequestImpl(SearchRequestImpl searchRequestImpl) {
        this._aggregationsMap.putAll(searchRequestImpl._aggregationsMap);
        this._basicFacetSelection = searchRequestImpl._basicFacetSelection;
        this._complexQueryParts.addAll(searchRequestImpl._complexQueryParts);
        this._connectionId = searchRequestImpl._connectionId;
        this._emptySearchEnabled = searchRequestImpl._emptySearchEnabled;
        this._excludeContributors.addAll(searchRequestImpl._excludeContributors);
        this._explain = searchRequestImpl._explain;
        this._federatedSearchKey = searchRequestImpl._federatedSearchKey;
        this._federatedSearchRequestsMap.putAll(searchRequestImpl._federatedSearchRequestsMap);
        this._from = searchRequestImpl._from;
        this._groupByRequests.addAll(searchRequestImpl._groupByRequests);
        this._highlight = searchRequestImpl._highlight;
        this._includeContributors.addAll(searchRequestImpl._includeContributors);
        this._includeResponseString = searchRequestImpl._includeResponseString;
        this._modelIndexerClassNames.addAll(searchRequestImpl._modelIndexerClassNames);
        this._pipelineAggregationsMap.putAll(searchRequestImpl._pipelineAggregationsMap);
        this._postFilterComplexQueryParts.addAll(searchRequestImpl._postFilterComplexQueryParts);
        this._postFilterQuery = searchRequestImpl._postFilterQuery;
        this._query = searchRequestImpl._query;
        this._rescoreQuery = searchRequestImpl._rescoreQuery;
        this._rescores.addAll(searchRequestImpl._rescores);
        this._searchContext = searchRequestImpl._searchContext;
        this._size = searchRequestImpl._size;
        this._sorts.addAll(searchRequestImpl._sorts);
        this._statsRequests.addAll(searchRequestImpl._statsRequests);
    }

    public void addAggregation(Aggregation aggregation) {
        this._aggregationsMap.put(aggregation.getName(), aggregation);
    }

    public void addComplexQueryPart(ComplexQueryPart complexQueryPart) {
        this._complexQueryParts.add(complexQueryPart);
    }

    public void addEntryClassNames(String ... entryClassNames) {
        this._searchContext.setEntryClassNames(entryClassNames);
    }

    public void addExcludeContributors(String ... ids) {
        Collections.addAll(this._excludeContributors, ids);
    }

    public void addFederatedSearchRequest(SearchRequest searchRequest) {
        this._federatedSearchRequestsMap.put(searchRequest.getFederatedSearchKey(), searchRequest);
    }

    public void addIncludeContributors(String ... ids) {
        Collections.addAll(this._includeContributors, ids);
    }

    public void addIndex(String index) {
        QueryConfig queryConfig = this._searchContext.getQueryConfig();
        queryConfig.setSelectedIndexNames((String[])ArrayUtil.append((Object[])queryConfig.getSelectedIndexNames(), (Object)index));
    }

    public void addPipelineAggregation(PipelineAggregation pipelineAggregation) {
        this._pipelineAggregationsMap.put(pipelineAggregation.getName(), pipelineAggregation);
    }

    public void addPostFilterQueryPart(ComplexQueryPart complexQueryPart) {
        this._postFilterComplexQueryParts.add(complexQueryPart);
    }

    public void addRescore(Rescore rescore) {
        this._rescores.add(rescore);
    }

    public void addSelectedFieldNames(String ... selectedFieldNames) {
        QueryConfig queryConfig = this._searchContext.getQueryConfig();
        queryConfig.addSelectedFieldNames(selectedFieldNames);
    }

    public void addSort(Sort sort) {
        this._sorts.add(sort);
    }

    public Map<String, Aggregation> getAggregationsMap() {
        return Collections.unmodifiableMap(this._aggregationsMap);
    }

    public List<ComplexQueryPart> getComplexQueryParts() {
        return Collections.unmodifiableList(this._complexQueryParts);
    }

    public String getConnectionId() {
        return this._connectionId;
    }

    public List<String> getEntryClassNames() {
        return Collections.unmodifiableList(Arrays.asList(this._searchContext.getEntryClassNames()));
    }

    public List<String> getExcludeContributors() {
        return Collections.unmodifiableList(this._excludeContributors);
    }

    public String getFederatedSearchKey() {
        return this._federatedSearchKey;
    }

    public List<SearchRequest> getFederatedSearchRequests() {
        return new ArrayList<SearchRequest>(this._federatedSearchRequestsMap.values());
    }

    public Boolean getFetchSource() {
        return this._fetchSource;
    }

    public String[] getFetchSourceExcludes() {
        return this._fetchSourceExcludes;
    }

    public String[] getFetchSourceIncludes() {
        return this._fetchSourceIncludes;
    }

    public Integer getFrom() {
        return this._from;
    }

    public List<GroupByRequest> getGroupByRequests() {
        return Collections.unmodifiableList(this._groupByRequests);
    }

    public Highlight getHighlight() {
        return this._highlight;
    }

    public List<String> getIncludeContributors() {
        return Collections.unmodifiableList(this._includeContributors);
    }

    public List<String> getIndexes() {
        QueryConfig queryConfig = this._searchContext.getQueryConfig();
        return Collections.unmodifiableList(Arrays.asList(queryConfig.getSelectedIndexNames()));
    }

    @Deprecated
    public List<Class<?>> getModelIndexerClasses() {
        return Collections.emptyList();
    }

    public List<String> getModelIndexerClassNames() {
        return this._modelIndexerClassNames;
    }

    public String getPaginationStartParameterName() {
        return this._paginationStartParameterName;
    }

    public Map<String, PipelineAggregation> getPipelineAggregationsMap() {
        return Collections.unmodifiableMap(this._pipelineAggregationsMap);
    }

    public List<ComplexQueryPart> getPostFilterComplexQueryParts() {
        return Collections.unmodifiableList(this._postFilterComplexQueryParts);
    }

    public Query getPostFilterQuery() {
        return this._postFilterQuery;
    }

    public Query getQuery() {
        return this._query;
    }

    public String getQueryString() {
        return this._searchContext.getKeywords();
    }

    @Deprecated
    public Query getRescoreQuery() {
        return this._rescoreQuery;
    }

    public List<Rescore> getRescores() {
        return this._rescores;
    }

    public SearchContext getSearchContext() {
        return this._searchContext;
    }

    public Integer getSize() {
        return this._size;
    }

    public List<Sort> getSorts() {
        return Collections.unmodifiableList(this._sorts);
    }

    public List<StatsRequest> getStatsRequests() {
        return Collections.unmodifiableList(this._statsRequests);
    }

    public boolean isBasicFacetSelection() {
        return this._basicFacetSelection;
    }

    public boolean isEmptySearchEnabled() {
        return this._emptySearchEnabled;
    }

    public boolean isExplain() {
        return this._explain;
    }

    public boolean isIncludeResponseString() {
        return this._includeResponseString;
    }

    public void setBasicFacetSelection(boolean basicFacetSelection) {
        this._basicFacetSelection = basicFacetSelection;
        this._searchContext.setAttribute("search.basic.facet.selection", (Serializable)Boolean.valueOf(basicFacetSelection));
    }

    public void setCompanyId(Long companyId) {
        this._searchContext.setCompanyId(GetterUtil.getLong((Object)companyId));
    }

    public void setConnectionId(String connectionId) {
        this._connectionId = connectionId;
    }

    public void setEmptySearchEnabled(boolean emptySearchEnabled) {
        this._emptySearchEnabled = emptySearchEnabled;
        this._searchContext.setAttribute("search.empty.search", (Serializable)Boolean.valueOf(emptySearchEnabled));
    }

    public void setExplain(boolean explain) {
        this._explain = explain;
    }

    public void setFederatedSearchKey(String federatedSearchKey) {
        this._federatedSearchKey = federatedSearchKey;
    }

    public void setFetchSource(boolean fetchSource) {
        this._fetchSource = fetchSource;
    }

    public void setFetchSourceExcludes(String[] fetchSourceExcludes) {
        this._fetchSourceExcludes = fetchSourceExcludes;
    }

    public void setFetchSourceIncludes(String[] fetchSourceIncludes) {
        this._fetchSourceIncludes = fetchSourceIncludes;
    }

    public void setFrom(Integer from) {
        this._from = from;
    }

    public void setGroupByRequests(GroupByRequest ... groupByRequests) {
        this._groupByRequests.clear();
        Collections.addAll(this._groupByRequests, groupByRequests);
    }

    public void setGroupIds(long ... groupIds) {
        this._searchContext.setGroupIds(groupIds);
    }

    public void setHighlight(Highlight highlight) {
        this._highlight = highlight;
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        QueryConfig queryConfig = this._searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(highlightEnabled);
    }

    public void setHighlightFields(String ... highlightFields) {
        QueryConfig queryConfig = this._searchContext.getQueryConfig();
        queryConfig.setHighlightFieldNames(highlightFields);
    }

    public void setIncludeResponseString(boolean includeResponseString) {
        this._includeResponseString = includeResponseString;
    }

    public void setIndexes(String ... indexes) {
        QueryConfig queryConfig = this._searchContext.getQueryConfig();
        queryConfig.setSelectedIndexNames(indexes);
    }

    public void setLocale(Locale locale) {
        this._searchContext.setLocale(locale);
    }

    public void setModelIndexerClassNames(String ... classNames) {
        this._modelIndexerClassNames.clear();
        Collections.addAll(this._modelIndexerClassNames, classNames);
    }

    public void setOwnerUserId(Long userId) {
        this._searchContext.setOwnerUserId(GetterUtil.getLong((Object)userId));
    }

    public void setPaginationStartParameterName(String paginationStartParameterName) {
        this._paginationStartParameterName = paginationStartParameterName;
    }

    public void setPostFilterQuery(Query query) {
        this._postFilterQuery = query;
    }

    public void setQuery(Query query) {
        this._query = query;
    }

    public void setQueryString(String queryString) {
        this._searchContext.setKeywords(queryString);
    }

    public void setRescores(List<Rescore> rescores) {
        this._rescores = rescores;
    }

    public void setSelectedFieldNames(String ... selectedFieldNames) {
        QueryConfig queryConfig = this._searchContext.getQueryConfig();
        queryConfig.setSelectedFieldNames(selectedFieldNames);
    }

    public void setSize(Integer size) {
        this._size = size;
    }

    public void setSorts(Sort ... sorts) {
        this._sorts.clear();
        Collections.addAll(this._sorts, sorts);
    }

    public void setStatsRequests(StatsRequest ... statsRequests) {
        this._statsRequests.clear();
        Collections.addAll(this._statsRequests, statsRequests);
    }
}

