/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.searcher;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.groupby.GroupByResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.hits.SearchHitsBuilder;
import com.liferay.portal.search.hits.SearchHitsBuilderFactory;
import com.liferay.portal.search.internal.hits.SearchHitsBuilderFactoryImpl;
import com.liferay.portal.search.internal.legacy.searcher.FacetContextImpl;
import com.liferay.portal.search.searcher.FacetContext;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.SearchTimeValue;
import com.liferay.portal.search.stats.StatsResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class SearchResponseImpl
implements SearchResponse,
Serializable {
    private final Map<String, AggregationResult> _aggregationResultsMap = new LinkedHashMap<String, AggregationResult>();
    private long _count;
    private final FacetContextImpl _facetContextImpl;
    private String _federatedSearchKey = "";
    private final Map<String, SearchResponse> _federatedSearchResponsesMap = new LinkedHashMap<String, SearchResponse>();
    private final List<GroupByResponse> _groupByResponses = new ArrayList<GroupByResponse>();
    private Hits _hits;
    private String _requestString = "";
    private String _responseString = "";
    private final SearchContext _searchContext;
    private SearchHits _searchHits;
    private final SearchHitsBuilderFactory _searchHitsBuilderFactory = new SearchHitsBuilderFactoryImpl();
    private SearchRequest _searchRequest;
    private SearchTimeValue _searchTimeValue;
    private final Map<String, StatsResponse> _statsResponseMap = new LinkedHashMap<String, StatsResponse>();

    public SearchResponseImpl(SearchContext searchContext) {
        this._searchContext = searchContext;
        this._facetContextImpl = new FacetContextImpl(searchContext);
    }

    public void addFederatedSearchResponse(SearchResponse searchResponse) {
        this._federatedSearchResponsesMap.put(searchResponse.getFederatedSearchKey(), searchResponse);
    }

    public AggregationResult getAggregationResult(String name) {
        return this._aggregationResultsMap.get(name);
    }

    public Map<String, AggregationResult> getAggregationResultsMap() {
        return Collections.unmodifiableMap(this._aggregationResultsMap);
    }

    public long getCount() {
        return this._count;
    }

    public List<Document> getDocuments71() {
        if (this._hits == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._hits.getDocs());
    }

    public Stream<com.liferay.portal.search.document.Document> getDocumentsStream() {
        if (this._searchHits == null) {
            return Stream.empty();
        }
        List list = this._searchHits.getSearchHits();
        return list.stream().map(SearchHit::getDocument);
    }

    public String getFederatedSearchKey() {
        return this._federatedSearchKey;
    }

    public SearchResponse getFederatedSearchResponse(String key) {
        if (Validator.isBlank((String)key)) {
            return this;
        }
        return this._federatedSearchResponsesMap.get(key);
    }

    public Stream<SearchResponse> getFederatedSearchResponsesStream() {
        Collection<SearchResponse> searchResponses = this._federatedSearchResponsesMap.values();
        return searchResponses.stream();
    }

    public List<GroupByResponse> getGroupByResponses() {
        return Collections.unmodifiableList(this._groupByResponses);
    }

    public SearchRequest getRequest() {
        return this._searchRequest;
    }

    public String getRequestString() {
        return this._requestString;
    }

    public String getResponseString() {
        return this._responseString;
    }

    public SearchHits getSearchHits() {
        if (this._searchHits == null) {
            SearchHitsBuilder searchHitsBuilder = this._searchHitsBuilderFactory.getSearchHitsBuilder();
            return searchHitsBuilder.build();
        }
        return this._searchHits;
    }

    public SearchTimeValue getSearchTimeValue() {
        return this._searchTimeValue;
    }

    public Map<String, StatsResponse> getStatsResponseMap() {
        return Collections.unmodifiableMap(this._statsResponseMap);
    }

    public int getTotalHits() {
        if (this._hits == null) {
            return 0;
        }
        return this._hits.getLength();
    }

    public void setAggregationResultsMap(Map<String, AggregationResult> aggregationResultsMap) {
        this._aggregationResultsMap.clear();
        this._aggregationResultsMap.putAll(aggregationResultsMap);
    }

    public void setCount(long count) {
        this._count = count;
    }

    public void setFederatedSearchKey(String federatedSearchKey) {
        this._federatedSearchKey = federatedSearchKey;
    }

    public void setGroupByResponses(List<GroupByResponse> groupByResponses) {
        this._groupByResponses.clear();
        this._groupByResponses.addAll(groupByResponses);
    }

    public void setHits(Hits hits) {
        this._hits = hits;
    }

    public void setRequest(SearchRequest searchRequest) {
        this._searchRequest = searchRequest;
    }

    public void setRequestString(String requestString) {
        this._requestString = GetterUtil.getString((String)requestString);
    }

    public void setResponseString(String responseString) {
        this._responseString = GetterUtil.getString((String)responseString);
    }

    public void setSearchHits(SearchHits searchHits) {
        this._searchHits = searchHits;
    }

    public void setSearchTimeValue(SearchTimeValue searchTimeValue) {
        this._searchTimeValue = searchTimeValue;
    }

    public void setStatsResponseMap(Map<String, StatsResponse> map) {
        this._statsResponseMap.clear();
        this._statsResponseMap.putAll(map);
    }

    public void withFacetContext(Consumer<FacetContext> facetContextConsumer) {
        facetContextConsumer.accept(this._facetContextImpl);
    }

    public <T> T withFacetContextGet(Function<FacetContext, T> facetContextFunction) {
        return facetContextFunction.apply(this._facetContextImpl);
    }

    public void withHits(Consumer<Hits> hitsConsumer) {
        hitsConsumer.accept(this._hits);
    }

    public <T> T withHitsGet(Function<Hits, T> hitsFunction) {
        return hitsFunction.apply(this._hits);
    }

    public void withSearchContext(Consumer<SearchContext> searchContextConsumer) {
        searchContextConsumer.accept(this._searchContext);
    }

    public <T> T withSearchContextGet(Function<SearchContext, T> function) {
        return function.apply(this._searchContext);
    }
}

