/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.searcher;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcher;
import com.liferay.portal.kernel.search.facet.faceted.searcher.FacetedSearcherManager;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.searcher.SearchRequestContributorsHolder;
import com.liferay.portal.search.internal.searcher.SearchRequestImpl;
import com.liferay.portal.search.internal.searcher.helper.IndexSearcherHelper;
import com.liferay.portal.search.legacy.searcher.SearchResponseBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.SearchResponseBuilder;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.spi.searcher.SearchRequestContributor;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Searcher.class})
public class SearcherImpl
implements Searcher {
    @Reference
    protected FacetedSearcherManager facetedSearcherManager;
    @Reference
    protected IndexerRegistry indexerRegistry;
    @Reference
    protected IndexSearcherHelper indexSearcherHelper;
    @Reference
    protected SearchRequestContributorsHolder searchRequestContributorsHolder;
    @Reference
    protected SearchResponseBuilderFactory searchResponseBuilderFactory;

    public SearchResponse search(SearchRequest searchRequest) {
        return this.doSearch(this._transformSearchRequest(searchRequest));
    }

    protected SearchResponse doSearch(SearchRequest searchRequest) {
        if (!(searchRequest instanceof SearchRequestImpl)) {
            throw new UnsupportedOperationException();
        }
        SearchRequestImpl searchRequestImpl = (SearchRequestImpl)searchRequest;
        SearchResponseBuilder searchResponseBuilder = this.searchResponseBuilderFactory.builder(searchRequestImpl.getSearchContext());
        this._smartSearch(searchRequestImpl, searchResponseBuilder);
        this._federatedSearches(searchRequestImpl, searchResponseBuilder);
        SearchContext searchContext = searchRequestImpl.getSearchContext();
        String exceptionMessage = (String)((Object)searchContext.getAttribute("search.exception.message"));
        if (Validator.isNotNull((String)exceptionMessage)) {
            searchResponseBuilder.responseString(exceptionMessage);
        }
        return searchResponseBuilder.federatedSearchKey(searchRequestImpl.getFederatedSearchKey()).request((SearchRequest)searchRequestImpl).build();
    }

    protected Hits search(FacetedSearcher facetedSearcher, SearchContext searchContext) {
        try {
            return facetedSearcher.search(searchContext);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    protected Hits search(Indexer<?> indexer, SearchContext searchContext) {
        try {
            return indexer.search(searchContext);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    private void _federatedSearches(SearchRequest searchRequest, SearchResponseBuilder searchResponseBuilder) {
        List federatedSearchRequests = searchRequest.getFederatedSearchRequests();
        for (SearchRequest federatedSearchRequest : federatedSearchRequests) {
            searchResponseBuilder.addFederatedSearchResponse(this.search(federatedSearchRequest));
        }
    }

    private Stream<Function<SearchRequest, SearchRequest>> _getContributors(SearchRequest searchRequest) {
        Stream<SearchRequestContributor> stream = this.searchRequestContributorsHolder.stream(searchRequest.getIncludeContributors(), searchRequest.getExcludeContributors());
        return stream.map(searchRequestContributor -> arg_0 -> ((SearchRequestContributor)searchRequestContributor).contribute(arg_0));
    }

    private String _getSingleIndexerClassName(SearchRequestImpl searchRequestImpl) {
        List<String> modelIndexerClassNames = searchRequestImpl.getModelIndexerClassNames();
        if (modelIndexerClassNames.size() == 1) {
            return modelIndexerClassNames.get(0);
        }
        return null;
    }

    private void _indexerSearch(SearchRequestImpl searchRequestImpl, SearchResponseBuilder searchResponseBuilder) {
        String singleIndexerClassName = this._getSingleIndexerClassName(searchRequestImpl);
        if (singleIndexerClassName != null) {
            this._singleIndexerSearch(singleIndexerClassName, searchRequestImpl, searchResponseBuilder);
        } else {
            this._multiIndexerSearch(searchRequestImpl, searchResponseBuilder);
        }
    }

    private boolean _isCount(SearchRequestImpl searchRequestImpl) {
        return searchRequestImpl.getSize() != null && searchRequestImpl.getSize() == 0;
    }

    private void _lowLevelSearch(SearchRequestImpl searchRequestImpl, SearchResponseBuilder searchResponseBuilder) {
        SearchContext searchContext = searchRequestImpl.getSearchContext();
        if (this._isCount(searchRequestImpl)) {
            this.indexSearcherHelper.searchCount(searchContext, null);
            return;
        }
        Hits hits = this.indexSearcherHelper.search(searchContext, null);
        searchResponseBuilder.hits(hits);
    }

    private void _multiIndexerSearch(SearchRequestImpl searchRequestImpl, SearchResponseBuilder searchResponseBuilder) {
        FacetedSearcher facetedSearcher = this.facetedSearcherManager.createFacetedSearcher();
        Hits hits = this.search(facetedSearcher, searchRequestImpl.getSearchContext());
        if (this._isCount(searchRequestImpl)) {
            searchResponseBuilder.count((long)hits.getLength());
            return;
        }
        searchResponseBuilder.hits(hits);
    }

    private long _searchCount(Indexer<?> indexer, SearchContext searchContext) {
        try {
            return indexer.searchCount(searchContext);
        }
        catch (SearchException searchException) {
            throw this._uncheck(searchException);
        }
    }

    private void _singleIndexerSearch(String singleIndexerClassName, SearchRequestImpl searchRequestImpl, SearchResponseBuilder searchResponseBuilder) {
        Indexer indexer = this.indexerRegistry.getIndexer(singleIndexerClassName);
        SearchContext searchContext = searchRequestImpl.getSearchContext();
        if (this._isCount(searchRequestImpl)) {
            searchResponseBuilder.count(this._searchCount(indexer, searchContext));
            return;
        }
        Hits hits = this.search(indexer, searchContext);
        searchResponseBuilder.hits(hits);
    }

    private void _smartSearch(SearchRequestImpl searchRequestImpl, SearchResponseBuilder searchResponseBuilder) {
        List<String> indexes = searchRequestImpl.getIndexes();
        if (indexes.isEmpty()) {
            this._indexerSearch(searchRequestImpl, searchResponseBuilder);
        } else {
            this._lowLevelSearch(searchRequestImpl, searchResponseBuilder);
        }
    }

    private <T> T _transform(T t, Stream<Function<T, T>> stream) {
        return stream.reduce((beforeFunction, afterFunction) -> beforeFunction.andThen(afterFunction)).orElse(Function.identity()).apply(t);
    }

    private SearchRequest _transformSearchRequest(SearchRequest searchRequest) {
        return this._transform(searchRequest, this._getContributors(searchRequest));
    }

    private RuntimeException _uncheck(SearchException searchException) {
        if (searchException.getCause() instanceof RuntimeException) {
            return (RuntimeException)searchException.getCause();
        }
        if (searchException.getCause() != null) {
            return new RuntimeException(searchException.getCause());
        }
        return new RuntimeException(searchException);
    }
}

