/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.spi.model.query.contributor;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.search.spi.model.query.contributor.QueryConfigContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.QueryConfigContributorHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"service.ranking:Integer=1"}, service={QueryConfigContributor.class})
public class DefaultSelectedFieldNamesQueryConfigContributor
implements QueryConfigContributor {
    public static final int RANKING = 1;

    public void contributeQueryConfigurations(SearchContext searchContext, QueryConfigContributorHelper queryConfigContributorHelper) {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (ArrayUtil.isNotEmpty((Object[])queryConfig.getSelectedFieldNames())) {
            return;
        }
        HashSet<String> selectedFieldNames = null;
        Object[] defaultSelectedFieldNames = queryConfigContributorHelper.getDefaultSelectedFieldNames();
        if (!ArrayUtil.isEmpty((Object[])defaultSelectedFieldNames)) {
            selectedFieldNames = SetUtil.fromArray((Object[])defaultSelectedFieldNames);
            if (searchContext.isIncludeAttachments() || searchContext.isIncludeDiscussions()) {
                selectedFieldNames.add("classNameId");
                selectedFieldNames.add("classPK");
            }
        }
        if (!ArrayUtil.isEmpty((Object[])queryConfigContributorHelper.getDefaultSelectedLocalizedFieldNames())) {
            if (selectedFieldNames == null) {
                selectedFieldNames = new HashSet<String>();
            }
            if (queryConfigContributorHelper.isSelectAllLocales()) {
                this._addSelectedLocalizedFieldNames(queryConfigContributorHelper, selectedFieldNames, LocaleUtil.toLanguageIds((Collection)LanguageUtil.getAvailableLocales()));
            } else {
                this._addSelectedLocalizedFieldNames(queryConfigContributorHelper, selectedFieldNames, LocaleUtil.toLanguageId((Locale)queryConfig.getLocale()));
            }
        }
        if (selectedFieldNames != null && !selectedFieldNames.isEmpty()) {
            queryConfig.setSelectedFieldNames(selectedFieldNames.toArray(new String[0]));
        }
    }

    private void _addSelectedLocalizedFieldNames(QueryConfigContributorHelper queryConfigContributorHelper, Set<String> selectedFieldNames, String ... languageIds) {
        for (String defaultLocalizedSelectedFieldName : queryConfigContributorHelper.getDefaultSelectedLocalizedFieldNames()) {
            selectedFieldNames.add(defaultLocalizedSelectedFieldName);
            for (String languageId : languageIds) {
                String localizedFieldName = LocalizationUtil.getLocalizedName((String)defaultLocalizedSelectedFieldName, (String)languageId);
                selectedFieldNames.add(localizedFieldName);
            }
        }
    }
}

