/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.spi.model.query.contributor.QueryPreFilterContributor;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={QueryPreFilterContributor.class})
public class GroupIdQueryPreFilterContributor
implements QueryPreFilterContributor {
    private GroupLocalService _groupLocalService;

    public void contribute(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] groupIds = searchContext.getGroupIds();
        if (ArrayUtil.isEmpty((long[])groupIds) || groupIds.length == 1 && groupIds[0] == 0L) {
            this._addInactiveGroupsBooleanFilter(booleanFilter, searchContext);
            return;
        }
        BooleanFilter scopeBooleanFilter = new BooleanFilter();
        this._addOwnerBooleanFilter(scopeBooleanFilter, searchContext);
        TermsFilter groupIdsTermsFilter = new TermsFilter("groupId");
        TermsFilter scopeGroupIdsTermsFilter = new TermsFilter("scopeGroupId");
        for (int i = 0; i < groupIds.length; ++i) {
            Group group;
            long groupId = groupIds[i];
            if (groupId <= 0L || !this._groupLocalService.isLiveGroupActive(group = this._getGroup(groupId))) continue;
            long parentGroupId = groupId;
            if (group.isLayout()) {
                parentGroupId = group.getParentGroupId();
            }
            groupIdsTermsFilter.addValue(String.valueOf(parentGroupId));
            groupIds[i] = parentGroupId;
            if (!group.isLayout() && !searchContext.isScopeStrict()) continue;
            scopeGroupIdsTermsFilter.addValue(String.valueOf(groupId));
        }
        if (!groupIdsTermsFilter.isEmpty()) {
            scopeBooleanFilter.add((Filter)groupIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        if (!scopeGroupIdsTermsFilter.isEmpty()) {
            scopeBooleanFilter.add((Filter)scopeGroupIdsTermsFilter, BooleanClauseOccur.MUST);
        }
        if (scopeBooleanFilter.hasClauses()) {
            booleanFilter.add((Filter)scopeBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    @Reference(unbind="-")
    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    private void _addInactiveGroupsBooleanFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        List inactiveGroupIds = this._groupLocalService.getGroupIds(searchContext.getCompanyId(), false);
        if (ListUtil.isEmpty((List)inactiveGroupIds)) {
            return;
        }
        TermsFilter groupIdTermsFilter = new TermsFilter("groupId");
        groupIdTermsFilter.addValues(ArrayUtil.toStringArray((Object[])inactiveGroupIds.toArray(new Long[0])));
        booleanFilter.add((Filter)groupIdTermsFilter, BooleanClauseOccur.MUST_NOT);
    }

    private void _addOwnerBooleanFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        long ownerUserId = searchContext.getOwnerUserId();
        if (ownerUserId > 0L) {
            booleanFilter.addRequiredTerm("userId", ownerUserId);
        }
    }

    private Group _getGroup(long groupId) {
        try {
            return this._groupLocalService.getGroup(groupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

