/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.suggestions.spi;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.petra.portlet.url.builder.PortletURLBuilder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.rest.dto.v1_0.SuggestionsContributorConfiguration;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.spi.suggestions.SuggestionsContributor;
import com.liferay.portal.search.suggestions.Suggestion;
import com.liferay.portal.search.suggestions.SuggestionBuilder;
import com.liferay.portal.search.suggestions.SuggestionBuilderFactory;
import com.liferay.portal.search.suggestions.SuggestionsContributorResults;
import com.liferay.portal.search.suggestions.SuggestionsContributorResultsBuilderFactory;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.List;
import java.util.Locale;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=true, immediate=true, property={"search.suggestions.contributor.name=basic"}, service={SuggestionsContributor.class})
public class BasicSuggestionsContributor
implements SuggestionsContributor {
    private static final Log _log = LogFactoryUtil.getLog(BasicSuggestionsContributor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SuggestionBuilderFactory _suggestionBuilderFactory;
    @Reference
    private SuggestionsContributorResultsBuilderFactory _suggestionsContributorResultsBuilderFactory;

    public SuggestionsContributorResults getSuggestionsContributorResults(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, SearchContext searchContext, SuggestionsContributorConfiguration suggestionsContributorConfiguration) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(searchContext, GetterUtil.getInteger((Object)suggestionsContributorConfiguration.getSize(), (int)5)));
        SearchHits searchHits = searchResponse.getSearchHits();
        if (searchHits.getTotalHits() == 0L) {
            return null;
        }
        return this._toSuggestionsContributorResults(suggestionsContributorConfiguration.getDisplayGroupName(), liferayPortletRequest, liferayPortletResponse, searchContext, searchHits.getSearchHits());
    }

    private Layout _fetchLayoutByFriendlyURL(long groupId, String friendlyURL) {
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, false, friendlyURL);
        if (layout != null) {
            return layout;
        }
        return this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, true, friendlyURL);
    }

    private String _getAssetURL(AssetRenderer<?> assetRenderer, AssetRendererFactory<?> assetRendererFactory, String entryClassName, long entryClassPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, Layout searchLayout) {
        try {
            if (searchLayout == null) {
                return "";
            }
            PortletURL viewContentURL = PortletURLBuilder.createLiferayPortletURL((LiferayPortletResponse)liferayPortletResponse, (long)searchLayout.getPlid(), (String)"com_liferay_portal_search_web_search_results_portlet_SearchResultsPortlet", (String)"RENDER_PHASE").setPortletMode(PortletMode.VIEW).setWindowState(WindowState.MAXIMIZED).buildPortletURL();
            MutableRenderParameters mutableRenderParameters = viewContentURL.getRenderParameters();
            mutableRenderParameters.setValue("mvcPath", "/view_content.jsp");
            AssetEntry assetEntry = this._assetEntryLocalService.getEntry(entryClassName, entryClassPK);
            mutableRenderParameters.setValue("assetEntryId", String.valueOf(assetEntry.getEntryId()));
            mutableRenderParameters.setValue("type", assetRendererFactory.getType());
            String viewURL = null;
            if (assetRenderer != null) {
                viewURL = assetRenderer.getURLViewInContext(liferayPortletRequest, liferayPortletResponse, viewContentURL.toString());
            }
            if (Validator.isNull(viewURL)) {
                viewURL = viewContentURL.toString();
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            return HttpComponentsUtil.setParameter((String)viewURL, (String)"p_l_back_url", (String)themeDisplay.getURLCurrent());
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to get view URL for class ", entryClassName, " with primary key ", entryClassPK}), (Throwable)exception);
            return "";
        }
    }

    private SearchRequest _getSearchRequest(SearchContext searchContext1, int size) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.withSearchContext(searchContext2 -> {
            searchContext2.setCompanyId(searchContext1.getCompanyId());
            searchContext2.setGroupIds(searchContext1.getGroupIds());
            searchContext2.setKeywords(searchContext1.getKeywords());
            searchContext2.setLocale(searchContext1.getLocale());
            searchContext2.setTimeZone(searchContext1.getTimeZone());
            searchContext2.setUserId(searchContext1.getUserId());
        });
        searchRequestBuilder.size(Integer.valueOf(size)).queryString(searchContext1.getKeywords()).from(Integer.valueOf(0));
        return searchRequestBuilder.build();
    }

    private Suggestion _getSuggestion(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, Locale locale, SearchHit searchHit, Layout searchLayout) {
        Document document = searchHit.getDocument();
        String entryClassName = document.getString("entryClassName");
        SuggestionBuilder suggestionBuilder = this._suggestionBuilderFactory.builder().attribute("fields", (Object)HashMapBuilder.put((Object)"entryClassName", (Object)entryClassName).build()).score(searchHit.getScore());
        String text = null;
        try {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)entryClassName);
            if (assetRendererFactory == null) {
                return null;
            }
            long entryClassPK = document.getLong("entryClassPK");
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(entryClassPK);
            if (assetRenderer != null) {
                suggestionBuilder.attribute("assetSearchSummary", (Object)assetRenderer.getSearchSummary(locale));
                suggestionBuilder.attribute("assetURL", (Object)this._getAssetURL(assetRenderer, assetRendererFactory, entryClassName, entryClassPK, liferayPortletRequest, liferayPortletResponse, searchLayout));
                text = assetRenderer.getTitle(locale);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (text == null) {
            text = this._getText(searchHit.getDocument(), locale);
        }
        return suggestionBuilder.text(text).build();
    }

    private String _getText(Document document, Locale locale) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        String text = document.getString(StringBundler.concat((String[])new String[]{"title", "_", languageId}));
        if (Validator.isBlank((String)text)) {
            text = document.getString("localized_title_" + languageId);
        }
        if (Validator.isBlank((String)text)) {
            text = document.getString(StringBundler.concat((String[])new String[]{"name", "_", languageId}));
        }
        if (Validator.isBlank((String)text)) {
            text = document.getString("title");
        }
        return text;
    }

    private SuggestionsContributorResults _toSuggestionsContributorResults(String displayGroupName, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, SearchContext searchContext, List<SearchHit> searchHits) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout searchLayout = this._fetchLayoutByFriendlyURL(themeDisplay.getScopeGroupId(), GetterUtil.getString((Object)searchContext.getAttribute("search.suggestions.destination.friendly.url")));
        return this._suggestionsContributorResultsBuilderFactory.builder().displayGroupName(displayGroupName).suggestions(TransformUtil.transform(searchHits, searchHit -> this._getSuggestion(liferayPortletRequest, liferayPortletResponse, searchContext.getLocale(), (SearchHit)searchHit, searchLayout))).build();
    }
}

