/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.summary;

import com.liferay.portal.kernel.search.highlight.HighlightUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.summary.SummaryImpl;
import com.liferay.portal.search.summary.Summary;
import com.liferay.portal.search.summary.SummaryBuilder;
import com.liferay.portal.util.HtmlImpl;
import java.util.ArrayList;
import java.util.Locale;

public class SummaryBuilderImpl
implements SummaryBuilder {
    private static final String[] _ESCAPE_SAFE_HIGHLIGHTS = new String[]{"[@HIGHLIGHT1@]", "[@HIGHLIGHT2@]"};
    private static final String[] _HIGHLIGHT_TAGS = new String[]{"<liferay-hl>", "</liferay-hl>"};
    private String _content;
    private boolean _escape = true;
    private boolean _highlight;
    private final Html _html = new HtmlImpl();
    private Locale _locale;
    private int _maxContentLength;
    private String _title;

    public Summary build() {
        return new SummaryImpl(this._buildTitle(), this._buildContent(), this._locale);
    }

    public void setContent(String content) {
        this._content = content;
    }

    public void setEscape(boolean escape) {
        this._escape = escape;
    }

    public void setHighlight(boolean highlight) {
        this._highlight = highlight;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setMaxContentLength(int maxContentLength) {
        this._maxContentLength = maxContentLength;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    private String _buildContent() {
        return this._buildText(this._content, true);
    }

    private String _buildText(String text, boolean checkMaxLength) {
        if (Validator.isNull((String)text)) {
            return "";
        }
        if (checkMaxLength && this._maxContentLength > 0) {
            text = this._shorten(text, this._maxContentLength);
        }
        if (this._escape) {
            text = this._escape(text);
        }
        if (this._highlight) {
            text = this._highlight(text);
        }
        return text;
    }

    private String _buildTitle() {
        return this._buildText(this._title, false);
    }

    private String _escape(String text) {
        text = StringUtil.replace((String)text, (String[])_HIGHLIGHT_TAGS, (String[])_ESCAPE_SAFE_HIGHLIGHTS);
        text = this._html.escape(text);
        return StringUtil.replace((String)text, (String[])_ESCAPE_SAFE_HIGHLIGHTS, (String[])_HIGHLIGHT_TAGS);
    }

    private String _highlight(String text) {
        return StringUtil.replace((String)text, (String[])_HIGHLIGHT_TAGS, (String[])HighlightUtil.HIGHLIGHTS);
    }

    private String _shorten(String text, int maxLength) {
        String originalText = text;
        ArrayList<Integer> closeTagIndexes = new ArrayList<Integer>();
        ArrayList<Integer> openTagIndexes = new ArrayList<Integer>();
        while (text.lastIndexOf("</liferay-hl>") != -1) {
            closeTagIndexes.add(text.lastIndexOf("</liferay-hl>"));
            text = StringUtil.removeLast((String)text, (String)"</liferay-hl>");
            openTagIndexes.add(text.lastIndexOf("<liferay-hl>"));
            text = StringUtil.removeLast((String)text, (String)"<liferay-hl>");
        }
        if (text.length() <= maxLength) {
            return originalText;
        }
        text = StringUtil.shorten((String)text, (int)maxLength);
        ListUtil.sort(closeTagIndexes);
        ListUtil.sort(openTagIndexes);
        for (int i = 0; i < openTagIndexes.size(); ++i) {
            int openTagIndex;
            int textEndIndex = text.length();
            if (text.endsWith("...")) {
                textEndIndex -= 3;
            }
            if ((openTagIndex = ((Integer)openTagIndexes.get(i)).intValue()) >= textEndIndex) break;
            text = StringUtil.insert((String)text, (String)"<liferay-hl>", (int)openTagIndex);
            int closeTagIndex = (Integer)closeTagIndexes.get(i);
            text = StringUtil.insert((String)text, (String)"</liferay-hl>", (int)Math.min(closeTagIndex, textEndIndex += "<liferay-hl>".length()));
        }
        return text;
    }
}

