/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.event.generators.user.management.internal.model.listener;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(User user) throws ModelListenerException {
        this.auditOnCreateOrRemove("ADD", user);
    }

    public void onBeforeRemove(User user) throws ModelListenerException {
        this.auditOnCreateOrRemove("DELETE", user);
    }

    public void onBeforeUpdate(User originalUser, User user) throws ModelListenerException {
        try {
            List<Attribute> attributes = this.getModifiedAttributes(originalUser, user);
            if (!attributes.isEmpty()) {
                AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)User.class.getName(), (long)user.getUserId(), attributes);
                this._auditRouter.route(auditMessage);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    protected void auditOnCreateOrRemove(String eventType, User user) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)User.class.getName(), (long)user.getUserId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("emailAddress", user.getEmailAddress()).put("screenName", user.getScreenName()).put("userId", user.getUserId()).put("userName", user.getFullName());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    protected List<Attribute> getModifiedAttributes(User originalUser, User user) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)user, (Object)originalUser);
        attributesBuilder.add("active");
        attributesBuilder.add("agreedToTermsOfUse");
        attributesBuilder.add("comments");
        attributesBuilder.add("emailAddress");
        attributesBuilder.add("languageId");
        attributesBuilder.add("reminderQueryAnswer");
        attributesBuilder.add("reminderQueryQuestion");
        attributesBuilder.add("screenName");
        attributesBuilder.add("timeZoneId");
        List attributes = attributesBuilder.getAttributes();
        if (attributes.removeIf(attribute -> Objects.equals(attribute.getName(), "reminderQueryAnswer"))) {
            attributes.add(new Attribute("reminderQueryAnswer"));
        }
        if (user.isPasswordModified()) {
            attributes.add(new Attribute("password"));
        }
        return attributes;
    }
}

