/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.router.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.security.audit.formatter.LogMessageFormatter;
import com.liferay.portal.security.audit.router.configuration.CSVLogMessageFormatterConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.security.audit.router.configuration.CSVLogMessageFormatterConfiguration"}, immediate=true, property={"format=CSV"}, service={LogMessageFormatter.class})
public class CSVLogMessageFormatter
implements LogMessageFormatter {
    private volatile String[] _columns;

    public String format(AuditMessage auditMessage) {
        StringBundler sb = new StringBundler(this._columns.length * 4 - 1);
        JSONObject jsonObject = auditMessage.toJSONObject();
        for (int i = 0; i < this._columns.length; ++i) {
            sb.append("\"");
            sb.append(jsonObject.getString(this._columns[i]));
            sb.append("\"");
            if (i + 1 >= this._columns.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        CSVLogMessageFormatterConfiguration csvLogMessageFormatterConfiguration = (CSVLogMessageFormatterConfiguration)ConfigurableUtil.createConfigurable(CSVLogMessageFormatterConfiguration.class, properties);
        this._columns = csvLogMessageFormatterConfiguration.columns();
    }
}

