/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.audit.storage.comparator.AuditEventCreateDateComparator;
import com.liferay.portal.security.audit.storage.model.AuditEvent;
import com.liferay.portal.security.audit.storage.service.base.AuditEventLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.portal.security.audit.storage.model.AuditEvent"}, service={AopService.class})
public class AuditEventLocalServiceImpl
extends AuditEventLocalServiceBaseImpl {
    public AuditEvent addAuditEvent(AuditMessage auditMessage) {
        long auditEventId = this.counterLocalService.increment();
        AuditEvent auditEvent = this.auditEventPersistence.create(auditEventId);
        auditEvent.setCompanyId(auditMessage.getCompanyId());
        auditEvent.setUserId(auditMessage.getUserId());
        auditEvent.setUserName(auditMessage.getUserName());
        auditEvent.setCreateDate(auditMessage.getTimestamp());
        auditEvent.setEventType(auditMessage.getEventType());
        auditEvent.setClassName(auditMessage.getClassName());
        auditEvent.setClassPK(auditMessage.getClassPK());
        auditEvent.setMessage(auditMessage.getMessage());
        auditEvent.setClientHost(auditMessage.getClientHost());
        auditEvent.setClientIP(auditMessage.getClientIP());
        auditEvent.setServerName(auditMessage.getServerName());
        auditEvent.setServerPort(auditMessage.getServerPort());
        auditEvent.setSessionID(auditMessage.getSessionID());
        auditEvent.setAdditionalInfo(String.valueOf(auditMessage.getAdditionalInfo()));
        return (AuditEvent)this.auditEventPersistence.update((BaseModel)auditEvent);
    }

    @Override
    public AuditEvent fetchAuditEvent(long auditEventId) {
        return this.auditEventPersistence.fetchByPrimaryKey(auditEventId);
    }

    public List<AuditEvent> getAuditEvents(long companyId, int start, int end) {
        return this.auditEventPersistence.findByCompanyId(companyId, start, end, (OrderByComparator)new AuditEventCreateDateComparator());
    }

    public List<AuditEvent> getAuditEvents(long companyId, int start, int end, OrderByComparator<AuditEvent> orderByComparator) {
        return this.auditEventPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<AuditEvent> getAuditEvents(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch, int start, int end) {
        return this.getAuditEvents(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch, start, end, (OrderByComparator<AuditEvent>)new AuditEventCreateDateComparator());
    }

    public List<AuditEvent> getAuditEvents(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch, int start, int end, OrderByComparator<AuditEvent> orderByComparator) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public int getAuditEventsCount(long companyId) {
        return this.auditEventPersistence.countByCompanyId(companyId);
    }

    public int getAuditEventsCount(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    protected DynamicQuery buildDynamicQuery(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch) {
        Property property;
        Property property2;
        Object junction = null;
        junction = andSearch ? RestrictionsFactoryUtil.conjunction() : RestrictionsFactoryUtil.disjunction();
        if (userId > 0L) {
            property2 = PropertyFactoryUtil.forName((String)"userId");
            junction.add(property2.eq((Object)userId));
        }
        if (Validator.isNotNull((String)userName)) {
            junction.add(RestrictionsFactoryUtil.ilike((String)"userName", (Object)("%" + userName + "%")));
        }
        if (Validator.isNotNull((String)eventType)) {
            property2 = PropertyFactoryUtil.forName((String)"eventType");
            String value = "%" + StringUtil.toUpperCase((String)eventType) + "%";
            junction.add(property2.like((Object)value));
        }
        if (Validator.isNotNull((String)className)) {
            junction.add(RestrictionsFactoryUtil.ilike((String)"className", (Object)("%" + className + "%")));
        }
        if (Validator.isNotNull((String)classPK)) {
            property2 = PropertyFactoryUtil.forName((String)"classPK");
            junction.add(property2.eq((Object)classPK));
        }
        if (Validator.isNotNull((String)clientHost)) {
            junction.add(RestrictionsFactoryUtil.ilike((String)"clientHost", (Object)("%" + clientHost + "%")));
        }
        if (Validator.isNotNull((String)clientIP)) {
            junction.add(RestrictionsFactoryUtil.ilike((String)"clientIP", (Object)("%" + clientIP + "%")));
        }
        if (Validator.isNotNull((String)serverName)) {
            junction.add(RestrictionsFactoryUtil.ilike((String)"serverName", (Object)("%" + serverName + "%")));
        }
        if (serverPort > 0) {
            property2 = PropertyFactoryUtil.forName((String)"serverPort");
            junction.add(property2.eq((Object)serverPort));
        }
        if (Validator.isNotNull((String)sessionID)) {
            junction.add(RestrictionsFactoryUtil.ilike((String)"sessionID", (Object)("%" + sessionID + "%")));
        }
        DynamicQuery dynamicQuery = this.dynamicQuery();
        if (companyId > 0L) {
            property = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(property.eq((Object)companyId));
        }
        if (createDateGT != null) {
            property = PropertyFactoryUtil.forName((String)"createDate");
            dynamicQuery.add(property.gt((Object)createDateGT));
        }
        if (createDateLT != null) {
            property = PropertyFactoryUtil.forName((String)"createDate");
            dynamicQuery.add(property.lt((Object)createDateLT));
        }
        return dynamicQuery.add((Criterion)junction);
    }
}

