/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.internal;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.audit.AuditEvent;
import com.liferay.portal.security.audit.AuditEventManager;
import com.liferay.portal.security.audit.storage.internal.AuditEventAutoEscapeBeanHandler;
import com.liferay.portal.security.audit.storage.service.AuditEventLocalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuditEventManager.class})
public class AuditEventManagerImpl
implements AuditEventManager {
    @Reference
    private AuditEventLocalService _auditEventLocalService;

    public AuditEvent addAuditEvent(AuditMessage auditMessage) {
        return this._createAuditEvent(this._auditEventLocalService.addAuditEvent(auditMessage));
    }

    public AuditEvent fetchAuditEvent(long auditEventId) {
        return this._createAuditEvent(this._auditEventLocalService.fetchAuditEvent(auditEventId));
    }

    public List<AuditEvent> getAuditEvents(long companyId, int start, int end, OrderByComparator<com.liferay.portal.security.audit.storage.model.AuditEvent> orderByComparator) {
        return this._translate(this._auditEventLocalService.getAuditEvents(companyId, start, end, orderByComparator));
    }

    public List<AuditEvent> getAuditEvents(long companyId, long groupId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch, int start, int end, OrderByComparator<com.liferay.portal.security.audit.storage.model.AuditEvent> orderByComparator) {
        return this._translate(this._auditEventLocalService.getAuditEvents(companyId, groupId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch, start, end, orderByComparator));
    }

    public int getAuditEventsCount(long companyId) {
        return this._auditEventLocalService.getAuditEventsCount(companyId);
    }

    public int getAuditEventsCount(long companyId, long groupId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch) {
        return this._auditEventLocalService.getAuditEventsCount(companyId, groupId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch);
    }

    private AuditEvent _createAuditEvent(com.liferay.portal.security.audit.storage.model.AuditEvent auditEventModel) {
        return AuditEventAutoEscapeBeanHandler.createProxy(auditEventModel);
    }

    private List<AuditEvent> _translate(List<com.liferay.portal.security.audit.storage.model.AuditEvent> auditEventModels) {
        if (auditEventModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AuditEvent> auditEvents = new ArrayList<AuditEvent>(auditEventModels.size());
        for (com.liferay.portal.security.audit.storage.model.AuditEvent auditEventModel : auditEventModels) {
            auditEvents.add(this._createAuditEvent(auditEventModel));
        }
        return auditEvents;
    }
}

