/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.security.audit.storage.model.AuditEvent;
import com.liferay.portal.security.audit.storage.service.AuditEventLocalService;
import com.liferay.portal.security.audit.storage.service.AuditEventLocalServiceUtil;
import com.liferay.portal.security.audit.storage.service.persistence.AuditEventPersistence;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class AuditEventLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
AuditEventLocalService,
IdentifiableOSGiService {
    protected AuditEventLocalService auditEventLocalService;
    @Reference
    protected AuditEventPersistence auditEventPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(AuditEventLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public AuditEvent addAuditEvent(AuditEvent auditEvent) {
        auditEvent.setNew(true);
        return (AuditEvent)this.auditEventPersistence.update((BaseModel)auditEvent);
    }

    @Transactional(enabled=false)
    public AuditEvent createAuditEvent(long auditEventId) {
        return this.auditEventPersistence.create(auditEventId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AuditEvent deleteAuditEvent(long auditEventId) throws PortalException {
        return this.auditEventPersistence.remove(auditEventId);
    }

    @Indexable(type=IndexableType.DELETE)
    public AuditEvent deleteAuditEvent(AuditEvent auditEvent) {
        return (AuditEvent)this.auditEventPersistence.remove((BaseModel)auditEvent);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.auditEventPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(AuditEvent.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.auditEventPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.auditEventPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.auditEventPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.auditEventPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.auditEventPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public AuditEvent fetchAuditEvent(long auditEventId) {
        return this.auditEventPersistence.fetchByPrimaryKey(auditEventId);
    }

    public AuditEvent getAuditEvent(long auditEventId) throws PortalException {
        return this.auditEventPersistence.findByPrimaryKey(auditEventId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.auditEventLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AuditEvent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("auditEventId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.auditEventLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(AuditEvent.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("auditEventId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.auditEventLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(AuditEvent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("auditEventId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.auditEventPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement AuditEventLocalServiceImpl#deleteAuditEvent(AuditEvent) to avoid orphaned data");
        }
        return this.auditEventLocalService.deleteAuditEvent((AuditEvent)persistedModel);
    }

    public BasePersistence<AuditEvent> getBasePersistence() {
        return this.auditEventPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.auditEventPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<AuditEvent> getAuditEvents(int start, int end) {
        return this.auditEventPersistence.findAll(start, end);
    }

    public int getAuditEventsCount() {
        return this.auditEventPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public AuditEvent updateAuditEvent(AuditEvent auditEvent) {
        return (AuditEvent)this.auditEventPersistence.update((BaseModel)auditEvent);
    }

    @Deactivate
    protected void deactivate() {
        AuditEventLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{AuditEventLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.auditEventLocalService = (AuditEventLocalService)aopProxy;
        AuditEventLocalServiceUtil.setService((AuditEventLocalService)this.auditEventLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return AuditEventLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return AuditEvent.class;
    }

    protected String getModelClassName() {
        return AuditEvent.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.auditEventPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

