/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.internal;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.audit.AuditEvent;
import com.liferay.portal.security.audit.AuditEventManager;
import com.liferay.portal.security.audit.storage.internal.AuditEventAutoEscapeBeanHandler;
import com.liferay.portal.security.audit.storage.service.AuditEventLocalService;
import com.liferay.portal.util.PortalInstances;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuditEventManager.class})
public class AuditEventManagerImpl
implements AuditEventManager {
    @Reference
    private AuditEventLocalService _auditEventLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;

    public AuditEvent addAuditEvent(AuditMessage auditMessage) {
        return this._createAuditEvent(this._auditEventLocalService.addAuditEvent(auditMessage));
    }

    public void addAuditEvents(List<AuditMessage> auditMessages) {
        if (DBPartition.isPartitionEnabled()) {
            HashMap<Long, List> auditMessagesMap = new HashMap<Long, List>();
            for (AuditMessage auditMessage : auditMessages) {
                List companyAuditMessages = auditMessagesMap.computeIfAbsent(auditMessage.getCompanyId(), key -> new ArrayList());
                companyAuditMessages.add(auditMessage);
            }
            for (Map.Entry entry : auditMessagesMap.entrySet()) {
                if (PortalInstances.isCompanyInDeletionProcess((long)((Long)entry.getKey())) || !ArrayUtil.contains((long[])PortalInstancePool.getCompanyIds(), (long)((Long)entry.getKey()))) continue;
                this._companyLocalService.forEachCompanyId(companyId -> this._auditEventLocalService.addAuditEvents((List)entry.getValue()), new long[]{(Long)entry.getKey()});
            }
        } else {
            this._auditEventLocalService.addAuditEvents(auditMessages);
        }
    }

    public AuditEvent fetchAuditEvent(long auditEventId) {
        return this._createAuditEvent(this._auditEventLocalService.fetchAuditEvent(auditEventId));
    }

    public List<AuditEvent> getAuditEvents(long companyId, int start, int end, OrderByComparator<com.liferay.portal.security.audit.storage.model.AuditEvent> orderByComparator) {
        return this._translate(this._auditEventLocalService.getAuditEvents(companyId, start, end, orderByComparator));
    }

    public List<AuditEvent> getAuditEvents(long companyId, long groupId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch, int start, int end, OrderByComparator<com.liferay.portal.security.audit.storage.model.AuditEvent> orderByComparator) {
        return this._translate(this._auditEventLocalService.getAuditEvents(companyId, groupId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch, start, end, orderByComparator));
    }

    public int getAuditEventsCount(long companyId) {
        return this._auditEventLocalService.getAuditEventsCount(companyId);
    }

    public int getAuditEventsCount(long companyId, long groupId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch) {
        return this._auditEventLocalService.getAuditEventsCount(companyId, groupId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch);
    }

    private AuditEvent _createAuditEvent(com.liferay.portal.security.audit.storage.model.AuditEvent auditEventModel) {
        return AuditEventAutoEscapeBeanHandler.createProxy(auditEventModel);
    }

    private List<AuditEvent> _translate(List<com.liferay.portal.security.audit.storage.model.AuditEvent> auditEventModels) {
        if (auditEventModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AuditEvent> auditEvents = new ArrayList<AuditEvent>(auditEventModels.size());
        for (com.liferay.portal.security.audit.storage.model.AuditEvent auditEventModel : auditEventModels) {
            auditEvents.add(this._createAuditEvent(auditEventModel));
        }
        return auditEvents;
    }
}

