/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.internal.model.listener;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.security.audit.storage.model.AuditEvent;
import com.liferay.portal.security.audit.storage.service.AuditEventLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    @Reference
    private AuditEventLocalService _auditEventLocalService;

    public void onAfterRemove(Company company) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._deleteAuditEvents(company);
            return null;
        });
    }

    private void _deleteAuditEvents(Company company) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._auditEventLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)company.getCompanyId())));
        actionableDynamicQuery.setPerformActionMethod(auditEvent -> this._auditEventLocalService.deleteAuditEvent((AuditEvent)auditEvent));
        actionableDynamicQuery.performActions();
    }
}

