/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.internal;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.audit.AuditEvent;
import com.liferay.portal.security.audit.AuditEventManager;
import com.liferay.portal.security.audit.storage.internal.AuditEventAutoEscapeBeanHandler;
import com.liferay.portal.security.audit.storage.service.AuditEventLocalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AuditEventManager.class})
public class AuditEventManagerImpl
implements AuditEventManager {
    @Reference
    private AuditEventLocalService _auditEventLocalService;

    public AuditEvent addAuditEvent(AuditMessage auditMessage) {
        com.liferay.portal.security.audit.storage.model.AuditEvent auditEvent = this._auditEventLocalService.addAuditEvent(auditMessage);
        return this.createAuditEvent(auditEvent);
    }

    public AuditEvent fetchAuditEvent(long auditEventId) {
        com.liferay.portal.security.audit.storage.model.AuditEvent auditEvent = this._auditEventLocalService.fetchAuditEvent(auditEventId);
        return this.createAuditEvent(auditEvent);
    }

    public List<AuditEvent> getAuditEvents(long companyId, int start, int end, OrderByComparator<com.liferay.portal.security.audit.storage.model.AuditEvent> orderByComparator) {
        List auditEvents = this._auditEventLocalService.getAuditEvents(companyId, start, end, orderByComparator);
        return this.translate(auditEvents);
    }

    public List<AuditEvent> getAuditEvents(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch, int start, int end, OrderByComparator<com.liferay.portal.security.audit.storage.model.AuditEvent> orderByComparator) {
        List auditEvents = this._auditEventLocalService.getAuditEvents(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch, start, end, orderByComparator);
        return this.translate(auditEvents);
    }

    public int getAuditEventsCount(long companyId) {
        return this._auditEventLocalService.getAuditEventsCount(companyId);
    }

    public int getAuditEventsCount(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch) {
        return this._auditEventLocalService.getAuditEventsCount(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch);
    }

    protected AuditEvent createAuditEvent(com.liferay.portal.security.audit.storage.model.AuditEvent auditEventModel) {
        return AuditEventAutoEscapeBeanHandler.createProxy(auditEventModel);
    }

    protected List<AuditEvent> translate(List<com.liferay.portal.security.audit.storage.model.AuditEvent> auditEventModels) {
        if (auditEventModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AuditEvent> auditEvents = new ArrayList<AuditEvent>(auditEventModels.size());
        for (com.liferay.portal.security.audit.storage.model.AuditEvent auditEventModel : auditEventModels) {
            auditEvents.add(this.createAuditEvent(auditEventModel));
        }
        return auditEvents;
    }
}

