/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.audit.storage.model.AuditEvent;
import com.liferay.portal.security.audit.storage.service.base.AuditEventServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@CTAware
@Component(property={"json.web.service.context.name=audit", "json.web.service.context.path=AuditEvent"}, service={AopService.class})
public class AuditEventServiceImpl
extends AuditEventServiceBaseImpl {
    public List<AuditEvent> getAuditEvents(long companyId, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin() && !this.userLocalService.hasRoleUser(companyId, "Analytics Administrator", permissionChecker.getUserId(), true)) {
            throw new PrincipalException();
        }
        return this.auditEventLocalService.getAuditEvents(companyId, start, end);
    }

    public List<AuditEvent> getAuditEvents(long companyId, int start, int end, OrderByComparator<AuditEvent> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin() && !this.userLocalService.hasRoleUser(companyId, "Analytics Administrator", permissionChecker.getUserId(), true)) {
            throw new PrincipalException();
        }
        return this.auditEventLocalService.getAuditEvents(companyId, start, end, orderByComparator);
    }

    public List<AuditEvent> getAuditEvents(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin() && !this.userLocalService.hasRoleUser(companyId, "Analytics Administrator", permissionChecker.getUserId(), true)) {
            throw new PrincipalException();
        }
        return this.auditEventLocalService.getAuditEvents(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch, start, end);
    }

    public List<AuditEvent> getAuditEvents(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch, int start, int end, OrderByComparator<AuditEvent> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin() && !this.userLocalService.hasRoleUser(companyId, "Analytics Administrator", permissionChecker.getUserId(), true)) {
            throw new PrincipalException();
        }
        return this.auditEventLocalService.getAuditEvents(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch, start, end, orderByComparator);
    }

    public int getAuditEventsCount(long companyId) throws PortalException {
        return this.auditEventLocalService.getAuditEventsCount(companyId);
    }

    public int getAuditEventsCount(long companyId, long userId, String userName, Date createDateGT, Date createDateLT, String eventType, String className, String classPK, String clientHost, String clientIP, String serverName, int serverPort, String sessionID, boolean andSearch) throws PortalException {
        return this.auditEventLocalService.getAuditEventsCount(companyId, userId, userName, createDateGT, createDateLT, eventType, className, classPK, clientHost, clientIP, serverName, serverPort, sessionID, andSearch);
    }
}

