/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.storage.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.security.audit.storage.exception.NoSuchEventException;
import com.liferay.portal.security.audit.storage.model.AuditEvent;
import com.liferay.portal.security.audit.storage.model.AuditEventTable;
import com.liferay.portal.security.audit.storage.model.impl.AuditEventImpl;
import com.liferay.portal.security.audit.storage.model.impl.AuditEventModelImpl;
import com.liferay.portal.security.audit.storage.service.persistence.AuditEventPersistence;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuditEventPersistence.class, BasePersistence.class})
public class AuditEventPersistenceImpl
extends BasePersistenceImpl<AuditEvent>
implements AuditEventPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AuditEventImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "auditEvent.companyId = ?";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_AUDITEVENT = "SELECT auditEvent FROM AuditEvent auditEvent";
    private static final String _SQL_SELECT_AUDITEVENT_WHERE = "SELECT auditEvent FROM AuditEvent auditEvent WHERE ";
    private static final String _SQL_COUNT_AUDITEVENT = "SELECT COUNT(auditEvent) FROM AuditEvent auditEvent";
    private static final String _SQL_COUNT_AUDITEVENT_WHERE = "SELECT COUNT(auditEvent) FROM AuditEvent auditEvent WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "auditEvent.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AuditEvent exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AuditEvent exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AuditEventPersistenceImpl.class);
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<AuditEvent> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<AuditEvent> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<AuditEvent> findByCompanyId(long companyId, int start, int end, OrderByComparator<AuditEvent> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<AuditEvent> findByCompanyId(long companyId, int start, int end, OrderByComparator<AuditEvent> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (AuditEvent auditEvent : list) {
                if (companyId == auditEvent.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_AUDITEVENT_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY auditEvent.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AuditEvent findByCompanyId_First(long companyId, OrderByComparator<AuditEvent> orderByComparator) throws NoSuchEventException {
        AuditEvent auditEvent = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (auditEvent != null) {
            return auditEvent;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEventException(sb.toString());
    }

    public AuditEvent fetchByCompanyId_First(long companyId, OrderByComparator<AuditEvent> orderByComparator) {
        List<AuditEvent> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AuditEvent findByCompanyId_Last(long companyId, OrderByComparator<AuditEvent> orderByComparator) throws NoSuchEventException {
        AuditEvent auditEvent = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (auditEvent != null) {
            return auditEvent;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEventException(sb.toString());
    }

    public AuditEvent fetchByCompanyId_Last(long companyId, OrderByComparator<AuditEvent> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<AuditEvent> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AuditEvent[] findByCompanyId_PrevAndNext(long auditEventId, long companyId, OrderByComparator<AuditEvent> orderByComparator) throws NoSuchEventException {
        AuditEvent auditEvent = this.findByPrimaryKey(auditEventId);
        Session session = null;
        try {
            session = this.openSession();
            AuditEvent[] array = new AuditEventImpl[]{this.getByCompanyId_PrevAndNext(session, auditEvent, companyId, orderByComparator, true), auditEvent, this.getByCompanyId_PrevAndNext(session, auditEvent, companyId, orderByComparator, false)};
            AuditEvent[] auditEventArray = array;
            return auditEventArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AuditEvent getByCompanyId_PrevAndNext(Session session, AuditEvent auditEvent, long companyId, OrderByComparator<AuditEvent> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_AUDITEVENT_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY auditEvent.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)auditEvent)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AuditEvent)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (AuditEvent auditEvent : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)auditEvent);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_AUDITEVENT_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AuditEventPersistenceImpl() {
        this.setModelClass(AuditEvent.class);
        this.setModelImplClass(AuditEventImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)AuditEventTable.INSTANCE);
    }

    public void cacheResult(AuditEvent auditEvent) {
        this.entityCache.putResult(AuditEventImpl.class, (Serializable)Long.valueOf(auditEvent.getPrimaryKey()), (Serializable)auditEvent);
    }

    public void cacheResult(List<AuditEvent> auditEvents) {
        for (AuditEvent auditEvent : auditEvents) {
            if (this.entityCache.getResult(AuditEventImpl.class, (Serializable)Long.valueOf(auditEvent.getPrimaryKey())) != null) continue;
            this.cacheResult(auditEvent);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AuditEventImpl.class);
        this.finderCache.clearCache(AuditEventImpl.class);
    }

    public void clearCache(AuditEvent auditEvent) {
        this.entityCache.removeResult(AuditEventImpl.class, (BaseModel)auditEvent);
    }

    public void clearCache(List<AuditEvent> auditEvents) {
        for (AuditEvent auditEvent : auditEvents) {
            this.entityCache.removeResult(AuditEventImpl.class, (BaseModel)auditEvent);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(AuditEventImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(AuditEventImpl.class, primaryKey);
        }
    }

    public AuditEvent create(long auditEventId) {
        AuditEventImpl auditEvent = new AuditEventImpl();
        auditEvent.setNew(true);
        auditEvent.setPrimaryKey(auditEventId);
        auditEvent.setCompanyId(CompanyThreadLocal.getCompanyId());
        return auditEvent;
    }

    public AuditEvent remove(long auditEventId) throws NoSuchEventException {
        return this.remove(Long.valueOf(auditEventId));
    }

    public AuditEvent remove(Serializable primaryKey) throws NoSuchEventException {
        Session session = null;
        try {
            session = this.openSession();
            AuditEvent auditEvent = (AuditEvent)session.get(AuditEventImpl.class, primaryKey);
            if (auditEvent == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchEventException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            AuditEvent auditEvent2 = (AuditEvent)this.remove((BaseModel)auditEvent);
            return auditEvent2;
        }
        catch (NoSuchEventException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AuditEvent removeImpl(AuditEvent auditEvent) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)auditEvent)) {
                auditEvent = (AuditEvent)session.get(AuditEventImpl.class, auditEvent.getPrimaryKeyObj());
            }
            if (auditEvent != null) {
                session.delete((Object)auditEvent);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (auditEvent != null) {
            this.clearCache(auditEvent);
        }
        return auditEvent;
    }

    public AuditEvent updateImpl(AuditEvent auditEvent) {
        boolean isNew = auditEvent.isNew();
        if (!(auditEvent instanceof AuditEventModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(auditEvent.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)auditEvent);
                throw new IllegalArgumentException("Implement ModelWrapper in auditEvent proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom AuditEvent implementation " + auditEvent.getClass());
        }
        AuditEventModelImpl auditEventModelImpl = (AuditEventModelImpl)auditEvent;
        if (isNew && auditEvent.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                auditEvent.setCreateDate(date);
            } else {
                auditEvent.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)auditEvent);
            } else {
                auditEvent = (AuditEvent)session.merge((Object)auditEvent);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(AuditEventImpl.class, (BaseModel)auditEventModelImpl, false, true);
        if (isNew) {
            auditEvent.setNew(false);
        }
        auditEvent.resetOriginalValues();
        return auditEvent;
    }

    public AuditEvent findByPrimaryKey(Serializable primaryKey) throws NoSuchEventException {
        AuditEvent auditEvent = (AuditEvent)this.fetchByPrimaryKey(primaryKey);
        if (auditEvent == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchEventException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return auditEvent;
    }

    public AuditEvent findByPrimaryKey(long auditEventId) throws NoSuchEventException {
        return this.findByPrimaryKey(Long.valueOf(auditEventId));
    }

    public AuditEvent fetchByPrimaryKey(long auditEventId) {
        return (AuditEvent)this.fetchByPrimaryKey(Long.valueOf(auditEventId));
    }

    public List<AuditEvent> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<AuditEvent> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<AuditEvent> findAll(int start, int end, OrderByComparator<AuditEvent> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<AuditEvent> findAll(int start, int end, OrderByComparator<AuditEvent> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_AUDITEVENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_AUDITEVENT;
                sql = sql.concat(" ORDER BY auditEvent.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (AuditEvent auditEvent : this.findAll()) {
            this.remove((BaseModel)auditEvent);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_AUDITEVENT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "auditEventId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_AUDITEVENT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AuditEventModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new AuditEventModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(AuditEventImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.portal.security.audit.storage.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.security.audit.storage.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.security.audit.storage.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class AuditEventModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private AuditEventModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            AuditEventModelImpl auditEventModelImpl = (AuditEventModelImpl)baseModel;
            long columnBitmask = auditEventModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return AuditEventModelArgumentsResolver._getValue(auditEventModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | AuditEventModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return AuditEventModelArgumentsResolver._getValue(auditEventModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return AuditEventImpl.class.getName();
        }

        public String getTableName() {
            return AuditEventTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(AuditEventModelImpl auditEventModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? auditEventModelImpl.getColumnOriginalValue(columnName) : auditEventModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= AuditEventModelImpl.getColumnBitmask("createDate");
        }
    }
}

