/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.audit.wiring.internal.servlet.filter;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogContext;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.servlet.TryFilter;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.security.audit.wiring.internal.configuration.AuditLogContextConfiguration;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.audit.wiring.internal.configuration.AuditLogContextConfiguration"}, enabled=false, property={"after-filter=Session Max Allowed Filter", "servlet-context-name=", "servlet-filter-name=Audit Filter", "url-pattern=/*", "url-regex-ignore-pattern=^/html/.+\\.(css|gif|html|ico|jpg|js|png)(\\?.*)?$"}, service={Filter.class})
public class AuditFilter
extends BaseFilter
implements TryFilter {
    private static final Log _log = LogFactoryUtil.getLog(AuditFilter.class);
    private AuditLogContext _auditLogContext;
    private AuditLogContextConfiguration _auditLogContextConfiguration;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Portal _portal;
    private ServiceRegistration<LogContext> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    public Object doFilterTry(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        auditRequestThreadLocal.setClientHost(httpServletRequest.getRemoteHost());
        String remoteAddr = httpServletRequest.getRemoteAddr();
        auditRequestThreadLocal.setClientIP(remoteAddr);
        auditRequestThreadLocal.setQueryString(httpServletRequest.getQueryString());
        String userEmailAddress = "";
        HttpSession httpSession = httpServletRequest.getSession();
        Long userId = (Long)httpSession.getAttribute("USER_ID");
        String userLogin = "";
        if (userId != null) {
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)this._portal.getCompanyId(httpServletRequest));){
                User user = this._userLocalService.fetchUser(userId.longValue());
                if (user != null) {
                    userEmailAddress = user.getEmailAddress();
                    auditRequestThreadLocal.setRealUserEmailAddress(userEmailAddress);
                    auditRequestThreadLocal.setRealUserId(userId.longValue());
                    userLogin = this._getUserLogin(user);
                    auditRequestThreadLocal.setRealUserLogin(userLogin);
                }
            }
        }
        StringBuffer sb = httpServletRequest.getRequestURL();
        auditRequestThreadLocal.setRequestURL(sb.toString());
        auditRequestThreadLocal.setServerName(httpServletRequest.getServerName());
        auditRequestThreadLocal.setServerPort(httpServletRequest.getServerPort());
        auditRequestThreadLocal.setSessionID(httpSession.getId());
        if (!this._auditLogContextConfiguration.enabled()) {
            return null;
        }
        String xRequestId = null;
        if (this._auditLogContextConfiguration.useIncomingXRequestId()) {
            xRequestId = httpServletRequest.getHeader("X-Request-Id");
        }
        if (!this._isValidXRequestId(xRequestId)) {
            xRequestId = PortalUUIDUtil.generate();
        }
        httpServletResponse.setHeader("X-Request-Id", xRequestId);
        this._auditLogContext.setContext(remoteAddr, this._portal.getCompanyId(httpServletRequest), httpServletRequest.getServerName(), userEmailAddress, userId, userLogin, xRequestId);
        return null;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._auditLogContext = new AuditLogContext();
        this._serviceRegistration = bundleContext.registerService(LogContext.class, (Object)this._auditLogContext, (Dictionary)new HashMapDictionary());
        this._auditLogContextConfiguration = (AuditLogContextConfiguration)ConfigurableUtil.createConfigurable(AuditLogContextConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    protected Log getLog() {
        return _log;
    }

    private String _getUserLogin(User user) {
        String authType = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"company.security.auth.type", (String)"");
        if (authType.equals("emailAddress")) {
            return user.getEmailAddress();
        }
        if (authType.equals("userId")) {
            return String.valueOf(user.getUserId());
        }
        if (authType.equals("screenName")) {
            return user.getScreenName();
        }
        return "";
    }

    private boolean _isValidXRequestId(String xRequestId) {
        if (Validator.isBlank((String)xRequestId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Incoming X-Request-Id is empty");
            }
            return false;
        }
        if (xRequestId.length() < 20 || xRequestId.length() > 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Incoming X-Request-Id has an invalid length: " + xRequestId.length()));
            }
            return false;
        }
        for (int i = 0; i < xRequestId.length(); ++i) {
            if (xRequestId.charAt(i) >= ' ' && xRequestId.charAt(i) <= '~') continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Incoming X-Request-Id contains invalid characters");
            }
            return false;
        }
        return true;
    }

    private class AuditLogContext
    implements LogContext {
        private final ThreadLocal<Map<String, String>> _contexts = new CentralizedThreadLocal(AuditLogContext.class + "._contexts", HashMap::new);

        public Map<String, String> getContext(String logName) {
            return this._contexts.get();
        }

        public String getName() {
            return AuditLogContext.class.getSimpleName();
        }

        public void setContext(String clientIP, long companyId, String serverName, String userEmailAddress, Long userId, String userLogin, String xRequestId) {
            this._contexts.set(HashMapBuilder.put((Object)"clientIP", (Object)clientIP).put((Object)"companyId", (Object)String.valueOf(companyId)).put((Object)"serverName", (Object)serverName).put((Object)"userEmailAddress", (Object)userEmailAddress).put((Object)"userId", (Object)(userId != null ? String.valueOf(userId) : "")).put((Object)"userLogin", (Object)userLogin).put((Object)"virtualHostName", () -> {
                Company company;
                if (companyId >= 0L && (company = AuditFilter.this._companyLocalService.fetchCompany(companyId)) != null) {
                    return company.getVirtualHostname();
                }
                return "";
            }).put((Object)"xRequestId", (Object)xRequestId).build());
        }
    }
}

