/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.module;

import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class BaseAuthVerifierPublisher {
    private ServiceRegistration<AuthVerifier> _authVerifierRegistration;

    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        Boolean enabled = GetterUtil.getBoolean((Object)properties.get("enabled"));
        if (enabled == null || !enabled.booleanValue()) {
            return;
        }
        AuthVerifier authVerifier = this.getAuthVerifierInstance();
        Class<?> clazz = authVerifier.getClass();
        String authVerifierPropertyName = AuthVerifierPipeline.getAuthVerifierPropertyName((String)clazz.getName());
        Hashtable<String, Object> authVerifierProperties = new Hashtable<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = this.translateKey(authVerifierPropertyName, entry.getKey());
            ((Dictionary)authVerifierProperties).put(key, entry.getValue());
        }
        this._authVerifierRegistration = bundleContext.registerService(AuthVerifier.class, (Object)authVerifier, authVerifierProperties);
    }

    protected void deactivate() {
        if (this._authVerifierRegistration != null) {
            this._authVerifierRegistration.unregister();
        }
    }

    protected abstract AuthVerifier getAuthVerifierInstance();

    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this.deactivate();
        this.activate(bundleContext, properties);
    }

    protected String translateKey(String authVerifierPropertyName, String key) {
        if (key.equals("hostsAllowed")) {
            key = "hosts.allowed";
        } else if (key.equals("urlsExcludes")) {
            key = "urls.excludes";
        } else if (key.equals("urlsIncludes")) {
            key = "urls.includes";
        }
        return authVerifierPropertyName + key;
    }
}

