/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal;

import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.security.auth.AuthVerifierPipeline;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

public abstract class BaseAuthVerifierPipelineConfigurator {
    private ServiceRegistration<AuthVerifierConfiguration> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        boolean enabled = GetterUtil.getBoolean((Object)properties.get("enabled"));
        if (!enabled) {
            return;
        }
        Class<? extends AuthVerifier> clazz = this.getAuthVerifierClass();
        String authVerifierPropertyName = AuthVerifierPipeline.getAuthVerifierPropertyName((String)clazz.getName());
        Properties translatedProperties = new Properties();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            translatedProperties.setProperty(this.translateKey(authVerifierPropertyName, entry.getKey()), String.valueOf(entry.getValue()));
        }
        AuthVerifierConfiguration authVerifierConfiguration = new AuthVerifierConfiguration();
        authVerifierConfiguration.setAuthVerifierClassName(clazz.getName());
        authVerifierConfiguration.setProperties(translatedProperties);
        this._serviceRegistration = bundleContext.registerService(AuthVerifierConfiguration.class, (Object)authVerifierConfiguration, (Dictionary)new HashMapDictionary());
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    protected abstract Class<? extends AuthVerifier> getAuthVerifierClass();

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this.deactivate();
        this.activate(bundleContext, properties);
    }

    protected String translateKey(String authVerifierPropertyName, String key) {
        if (key.equals("hostsAllowed")) {
            key = "hosts.allowed";
        } else if (key.equals("urlsExcludes")) {
            key = "urls.excludes";
        } else if (key.equals("urlsIncludes")) {
            key = "urls.includes";
        }
        return key;
    }
}

