/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.request.parameter;

import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AuthVerifier.class})
public class RequestParameterAuthVerifier
implements AuthVerifier {
    @Reference(target="(&(private.auto.login=true)(type=request.parameter))")
    private AutoLogin _autoLogin;

    public String getAuthType() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            String[] credentials = this._autoLogin.login(accessControlContext.getRequest(), accessControlContext.getResponse());
            if (credentials != null) {
                authVerifierResult.setPassword(credentials[1]);
                authVerifierResult.setPasswordBasedAuthentication(true);
                authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
                authVerifierResult.setUserId(Long.valueOf(credentials[0]).longValue());
            }
            return authVerifierResult;
        }
        catch (AutoLoginException autoLoginException) {
            throw new AuthException((Throwable)autoLoginException);
        }
    }
}

