/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.verifier.internal.tracker;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.osgi.util.StringPlus;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, property={"default.registration.property=filter.init.auth.verifier.BasicAuthHeaderAuthVerifier.urls.includes=*", "default.registration.property=filter.init.auth.verifier.OAuth2RESTAuthVerifier.urls.includes=*", "default.registration.property=filter.init.auth.verifier.PortalSessionAuthVerifier.urls.includes=*", "default.registration.property=filter.init.guest.allowed=true", "default.remote.access.filter.service.ranking:Integer=-10", "default.whiteboard.property=osgi.http.whiteboard.filter.servlet=cxf-servlet", "servlet.context.helper.select.filter=(!(liferay.auth.verifier=false))"}, service={})
public class AuthVerifierFilterTracker {
    public static final String AUTH_VERIFIER_PROPERTY_PREFIX = "auth.verifier.";
    public static final int AUTH_VERIFIER_PROPERTY_PREFIX_LENGTH = "auth.verifier.".length();
    private static final Log _log = LogFactoryUtil.getLog(AuthVerifierFilterTracker.class);
    private BundleContext _bundleContext;
    private Dictionary<String, Object> _defaultRegistrationProperties;
    private int _defaultRemoteAccessFilterServiceRanking;
    private Dictionary<String, Object> _defaultWhiteboardProperties;
    private ServiceTracker<?, ?> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._defaultRegistrationProperties = this.toDictionary(StringPlus.asList((Object)properties.get("default.registration.property")));
        this._defaultRemoteAccessFilterServiceRanking = MapUtil.getInteger(properties, (String)"default.remote.access.filter.service.ranking", (int)-10);
        this._defaultWhiteboardProperties = this.toDictionary(StringPlus.asList((Object)properties.get("default.whiteboard.property")));
        String servletContextHelperSelectFilterString = MapUtil.getString(properties, (String)"servlet.context.helper.select.filter");
        String filterString = StringBundler.concat((String[])new String[]{"(&", servletContextHelperSelectFilterString, "(", "osgi.http.whiteboard.context.name", "=*)", "(objectClass=", ServletContextHelper.class.getName(), "))"});
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, (String)filterString, (ServiceTrackerCustomizer)new ServletContextHelperServiceTrackerCustomizer());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    protected Dictionary<String, Object> toDictionary(List<String> propertiesList) {
        HashMapDictionary dictionary = new HashMapDictionary();
        for (String property : propertiesList) {
            int index = property.indexOf("=");
            if (index == -1) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Invalid property " + property));
                continue;
            }
            String propertyKey = property.substring(0, index);
            String propertyValue = "";
            if (index < property.length()) {
                propertyValue = property.substring(index + 1);
            }
            dictionary.put(propertyKey, propertyValue);
        }
        return dictionary;
    }

    private class ServletContextHelperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletContextHelper, ServiceRegistrations> {
        private ServletContextHelperServiceTrackerCustomizer() {
        }

        public ServiceRegistrations addingService(ServiceReference<ServletContextHelper> serviceReference) {
            return new ServiceRegistrations((ServiceRegistration<Filter>)AuthVerifierFilterTracker.this._bundleContext.registerService(Filter.class, (Object)new AuthVerifierFilter(), this._buildPropertiesForAuthVerifierFilter(serviceReference)), (ServiceRegistration<Filter>)AuthVerifierFilterTracker.this._bundleContext.registerService(Filter.class, (Object)new RemoteAccessFilter(), this._buildPropertiesForRemoteAccessFilter(serviceReference)));
        }

        public void modifiedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistrations serviceRegistrations) {
            ServiceRegistration<Filter> authVerifierFilterServiceRegistration = serviceRegistrations.getAuthVerifierFilterServiceRegistration();
            authVerifierFilterServiceRegistration.setProperties(this._buildPropertiesForAuthVerifierFilter(serviceReference));
            ServiceRegistration<Filter> remoteAccessFilterServiceRegistration = serviceRegistrations.getRemoteAccessFilterServiceRegistration();
            remoteAccessFilterServiceRegistration.setProperties(this._buildPropertiesForRemoteAccessFilter(serviceReference));
        }

        public void removedService(ServiceReference<ServletContextHelper> serviceReference, ServiceRegistrations serviceRegistrations) {
            ServiceRegistration<Filter> authVerifierFilterServiceRegistration = serviceRegistrations.getAuthVerifierFilterServiceRegistration();
            authVerifierFilterServiceRegistration.unregister();
            ServiceRegistration<Filter> remoteAccessFilterServiceRegistration = serviceRegistrations.getRemoteAccessFilterServiceRegistration();
            remoteAccessFilterServiceRegistration.unregister();
        }

        private Dictionary<String, Object> _buildPropertiesForAuthVerifierFilter(ServiceReference<ServletContextHelper> serviceReference) {
            HashMapDictionaryBuilder.HashMapDictionaryWrapper properties = HashMapDictionaryBuilder.putAll((Dictionary)AuthVerifierFilterTracker.this._defaultRegistrationProperties);
            for (String key : serviceReference.getPropertyKeys()) {
                if (!key.startsWith(AuthVerifierFilterTracker.AUTH_VERIFIER_PROPERTY_PREFIX)) continue;
                properties.put((Object)("filter.init." + key.substring(AUTH_VERIFIER_PROPERTY_PREFIX_LENGTH)), serviceReference.getProperty(key));
            }
            this._putWhiteboardProperties((HashMapDictionaryBuilder.HashMapDictionaryWrapper<String, Object>)properties, serviceReference);
            return properties.build();
        }

        private Dictionary<String, Object> _buildPropertiesForRemoteAccessFilter(ServiceReference<ServletContextHelper> serviceReference) {
            HashMapDictionaryBuilder.HashMapDictionaryWrapper properties = new HashMapDictionaryBuilder.HashMapDictionaryWrapper();
            this._putWhiteboardProperties((HashMapDictionaryBuilder.HashMapDictionaryWrapper<String, Object>)properties, serviceReference);
            Object serviceRanking = AuthVerifierFilterTracker.this._defaultWhiteboardProperties.get("remote.access.filter.service.ranking");
            if (serviceRanking != null) {
                properties.put((Object)"service.ranking", serviceRanking);
            } else {
                properties.put((Object)"service.ranking", (Object)AuthVerifierFilterTracker.this._defaultRemoteAccessFilterServiceRanking);
            }
            return properties.build();
        }

        private void _putWhiteboardProperties(HashMapDictionaryBuilder.HashMapDictionaryWrapper<String, Object> properties, ServiceReference<ServletContextHelper> serviceReference) {
            properties.putAll(AuthVerifierFilterTracker.this._defaultWhiteboardProperties);
            for (String key : serviceReference.getPropertyKeys()) {
                if (!key.startsWith("osgi.http.whiteboard")) continue;
                properties.put((Object)key, serviceReference.getProperty(key));
            }
            String contextName = GetterUtil.getString((Object)serviceReference.getProperty("osgi.http.whiteboard.context.name"));
            properties.put((Object)"osgi.http.whiteboard.context.select", (Object)StringBundler.concat((String[])new String[]{"(", "osgi.http.whiteboard.context.name", "=", contextName, ")"}));
        }
    }

    private static class ServiceRegistrations {
        private final ServiceRegistration<Filter> _authVerifierFilterServiceRegistration;
        private final ServiceRegistration<Filter> _remoteAccessFilterServiceRegistration;

        public ServiceRegistrations(ServiceRegistration<Filter> authVerifierFilterServiceRegistration, ServiceRegistration<Filter> remoteAccessFilterServiceRegistration) {
            this._authVerifierFilterServiceRegistration = authVerifierFilterServiceRegistration;
            this._remoteAccessFilterServiceRegistration = remoteAccessFilterServiceRegistration;
        }

        public ServiceRegistration<Filter> getAuthVerifierFilterServiceRegistration() {
            return this._authVerifierFilterServiceRegistration;
        }

        public ServiceRegistration<Filter> getRemoteAccessFilterServiceRegistration() {
            return this._remoteAccessFilterServiceRegistration;
        }
    }

    private static class RemoteAccessFilter
    implements Filter {
        private RemoteAccessFilter() {
        }

        public void destroy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
            AccessControlThreadLocal.setRemoteAccess((boolean)true);
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
            }
        }

        public void init(FilterConfig filterConfig) {
        }
    }
}

