/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.remember.me;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AutoLogin.class})
public class RememberMeAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(RememberMeAutoLogin.class);
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    protected String[] doHandleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws AutoLoginException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)exception, (Throwable)exception);
        }
        this.removeCookies(httpServletRequest, httpServletResponse);
        throw new AutoLoginException((Throwable)exception);
    }

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Company company;
        String contextPath;
        String autoUserId = CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)"ID", (boolean)false);
        String autoPassword = CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)"PASSWORD", (boolean)false);
        String rememberMe = CookieKeys.getCookie((HttpServletRequest)httpServletRequest, (String)"REMEMBER_ME", (boolean)false);
        String proxyPath = this._portal.getPathProxy();
        if (proxyPath.equals(contextPath = this._portal.getPathContext())) {
            if (Validator.isNotNull((String)httpServletRequest.getContextPath())) {
                rememberMe = Boolean.TRUE.toString();
            }
        } else if (!contextPath.equals(httpServletRequest.getContextPath())) {
            rememberMe = Boolean.TRUE.toString();
        }
        String[] credentials = null;
        if (Validator.isNotNull((String)autoUserId) && Validator.isNotNull((String)autoPassword) && Validator.isNotNull((String)rememberMe) && (company = this._portal.getCompany(httpServletRequest)).isAutoLogin()) {
            KeyValuePair kvp = this._userLocalService.decryptUserId(company.getCompanyId(), autoUserId, autoPassword);
            credentials = new String[]{kvp.getKey(), kvp.getValue(), Boolean.FALSE.toString()};
        }
        if (credentials != null) {
            company = this._portal.getCompany(httpServletRequest);
            User defaultUser = this._userLocalService.getDefaultUser(company.getCompanyId());
            long userId = GetterUtil.getLong((String)credentials[0]);
            if (defaultUser.getUserId() == userId) {
                this.removeCookies(httpServletRequest, httpServletResponse);
                return null;
            }
        }
        return credentials;
    }

    protected void removeCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Cookie cookie = new Cookie("ID", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)cookie);
        cookie = new Cookie("PASSWORD", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)cookie);
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

