/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.request.parameter;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"private.auto.login=true", "type=request.parameter"}, service={AutoLogin.class})
public class RequestParameterAutoLoginSupport
extends BaseAutoLogin {
    private static final String _LOGIN_PARAM = "parameterAutoLoginLogin";
    private static final String _PASSWORD_PARAM = "parameterAutoLoginPassword";
    private Portal _portal;
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String login = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)this.getLoginParam());
        if (Validator.isNull((String)login)) {
            return null;
        }
        String password = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)this.getPasswordParam());
        if (Validator.isNull((String)password)) {
            return null;
        }
        Company company = this._portal.getCompany(httpServletRequest);
        String authType = company.getAuthType();
        long userId = 0L;
        if (authType.equals("emailAddress")) {
            userId = this._userLocalService.getUserIdByEmailAddress(company.getCompanyId(), login);
        } else if (authType.equals("screenName")) {
            userId = this._userLocalService.getUserIdByScreenName(company.getCompanyId(), login);
        } else if (authType.equals("userId")) {
            userId = GetterUtil.getLong((String)login);
        } else {
            return null;
        }
        if (userId > 0L) {
            User user = this._userLocalService.getUserById(userId);
            String userPassword = user.getPassword();
            if (!user.isPasswordEncrypted()) {
                userPassword = PasswordEncryptorUtil.encrypt((String)userPassword);
            }
            String encPassword = PasswordEncryptorUtil.encrypt((String)password, (String)userPassword);
            if (!userPassword.equals(password) && !userPassword.equals(encPassword)) {
                return null;
            }
        }
        return new String[]{String.valueOf(userId), password, Boolean.FALSE.toString()};
    }

    protected String getLoginParam() {
        return _LOGIN_PARAM;
    }

    protected String getPasswordParam() {
        return _PASSWORD_PARAM;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this._portal = portal;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

