/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.basic.auth.header;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.auto.login.internal.basic.auth.header.configuration.BasicAuthHeaderAutoLoginConfiguration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.auto.login.internal.basic.auth.header.configuration.BasicAuthHeaderAutoLoginConfiguration"}, property={"type=basic.auth.header"}, service={AutoLogin.class})
public class BasicAuthHeaderAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(BasicAuthHeaderAutoLogin.class);
    @Reference(target="(&(private.auto.login=true)(type=basic.auth.header))")
    private AutoLogin _autoLogin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.isEnabled(this._portal.getCompanyId(httpServletRequest))) {
            return null;
        }
        return this._autoLogin.login(httpServletRequest, httpServletResponse);
    }

    protected boolean isEnabled(long companyId) {
        BasicAuthHeaderAutoLoginConfiguration basicAuthHeaderAutoLoginConfiguration = this._getBasicAuthHeaderAutoLoginConfiguration(companyId);
        if (basicAuthHeaderAutoLoginConfiguration == null) {
            return false;
        }
        return basicAuthHeaderAutoLoginConfiguration.enabled();
    }

    private BasicAuthHeaderAutoLoginConfiguration _getBasicAuthHeaderAutoLoginConfiguration(long companyId) {
        try {
            return (BasicAuthHeaderAutoLoginConfiguration)this._configurationProvider.getConfiguration(BasicAuthHeaderAutoLoginConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.auto.login.basic.auth.header", BasicAuthHeaderAutoLoginConfiguration.class.getName()));
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to get basic auth header configuration", (Throwable)configurationException);
            return null;
        }
    }
}

