/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.remember.me;

import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.AutoLoginException;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AutoLogin.class})
public class RememberMeAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(RememberMeAutoLogin.class);
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doHandleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception) throws AutoLoginException {
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)exception);
        }
        this.removeCookies(httpServletRequest, httpServletResponse);
        throw new AutoLoginException((Throwable)exception);
    }

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Company company;
        String contextPath;
        String autoUserId = CookiesManagerUtil.getCookieValue((String)"ID", (HttpServletRequest)httpServletRequest, (boolean)false);
        String autoPassword = CookiesManagerUtil.getCookieValue((String)"PASSWORD", (HttpServletRequest)httpServletRequest, (boolean)false);
        String rememberMe = CookiesManagerUtil.getCookieValue((String)"REMEMBER_ME", (HttpServletRequest)httpServletRequest, (boolean)false);
        String proxyPath = this._portal.getPathProxy();
        if (proxyPath.equals(contextPath = this._portal.getPathContext())) {
            if (Validator.isNotNull((String)httpServletRequest.getContextPath())) {
                rememberMe = Boolean.TRUE.toString();
            }
        } else if (!contextPath.equals(httpServletRequest.getContextPath())) {
            rememberMe = Boolean.TRUE.toString();
        }
        String[] credentials = null;
        if (Validator.isNotNull((String)autoUserId) && Validator.isNotNull((String)autoPassword) && Validator.isNotNull((String)rememberMe) && (company = this._portal.getCompany(httpServletRequest)).isAutoLogin()) {
            KeyValuePair kvp = this._userLocalService.decryptUserId(company.getCompanyId(), autoUserId, autoPassword);
            credentials = new String[]{kvp.getKey(), kvp.getValue(), Boolean.FALSE.toString()};
        }
        if (credentials != null) {
            company = this._portal.getCompany(httpServletRequest);
            User guestUser = this._userLocalService.getGuestUser(company.getCompanyId());
            long userId = GetterUtil.getLong((String)credentials[0]);
            if (guestUser.getUserId() == userId) {
                this.removeCookies(httpServletRequest, httpServletResponse);
                return null;
            }
        }
        return credentials;
    }

    protected void removeCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String domain = CookiesManagerUtil.getDomain((HttpServletRequest)httpServletRequest);
        CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"ID"});
        CookiesManagerUtil.deleteCookies((String)domain, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String[])new String[]{"PASSWORD"});
    }
}

