/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.request.header;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auto.login.internal.request.header.configuration.RequestHeaderAutoLoginConfiguration;
import com.liferay.portal.security.exportimport.UserImporter;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.auto.login.internal.request.header.configuration.RequestHeaderAutoLoginConfiguration"}, service={AutoLogin.class})
public class RequestHeaderAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(RequestHeaderAutoLogin.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference
    private UserImporter _userImporter;
    @Reference
    private UserLocalService _userLocalService;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        User user;
        String screenName;
        long companyId;
        block10: {
            companyId = this._portal.getCompanyId(httpServletRequest);
            if (!this.isEnabled(companyId)) {
                return null;
            }
            String remoteAddr = httpServletRequest.getRemoteAddr();
            if (this.isAccessAllowed(companyId, httpServletRequest)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Access allowed for " + remoteAddr));
                }
            } else {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Access denied for " + remoteAddr));
                }
                return null;
            }
            screenName = httpServletRequest.getHeader("LIFERAY_SCREEN_NAME");
            if (Validator.isNull((String)screenName)) {
                return null;
            }
            user = null;
            if (this.isLDAPImportEnabled(companyId)) {
                try {
                    user = this._userImporter.importUser(companyId, "", screenName);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block10;
                    _log.debug((Throwable)exception);
                }
            }
        }
        if (user == null) {
            user = this._userLocalService.getUserByScreenName(companyId, screenName);
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }

    protected boolean isAccessAllowed(long companyId, HttpServletRequest httpServletRequest) {
        RequestHeaderAutoLoginConfiguration requestHeaderAutoLoginConfiguration = this._getRequestHeaderAutoLoginConfiguration(companyId);
        if (requestHeaderAutoLoginConfiguration == null) {
            return false;
        }
        String[] hostsAllowedArray = StringUtil.split((String)requestHeaderAutoLoginConfiguration.authHostsAllowed());
        HashSet<String> hostsAllowed = new HashSet<String>();
        for (String hostAllowed : hostsAllowedArray) {
            hostsAllowed.add(hostAllowed);
        }
        return AccessControlUtil.isAccessAllowed((HttpServletRequest)httpServletRequest, hostsAllowed);
    }

    protected boolean isEnabled(long companyId) {
        RequestHeaderAutoLoginConfiguration requestHeaderAutoLoginConfiguration = this._getRequestHeaderAutoLoginConfiguration(companyId);
        if (requestHeaderAutoLoginConfiguration == null) {
            return false;
        }
        return requestHeaderAutoLoginConfiguration.enabled();
    }

    protected boolean isLDAPImportEnabled(long companyId) {
        RequestHeaderAutoLoginConfiguration requestHeaderAutoLoginConfiguration = this._getRequestHeaderAutoLoginConfiguration(companyId);
        if (requestHeaderAutoLoginConfiguration == null) {
            return false;
        }
        return requestHeaderAutoLoginConfiguration.importFromLDAP();
    }

    private RequestHeaderAutoLoginConfiguration _getRequestHeaderAutoLoginConfiguration(long companyId) {
        try {
            return (RequestHeaderAutoLoginConfiguration)this._configurationProvider.getConfiguration(RequestHeaderAutoLoginConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.auto.login.request.header"));
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to get request header auto login configuration", (Throwable)configurationException);
            return null;
        }
    }
}

