/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auto.login.request.parameter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auto.login.AutoLogin;
import com.liferay.portal.kernel.security.auto.login.BaseAutoLogin;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.auto.login.internal.request.parameter.configuration.RequestParameterAutoLoginConfiguration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.security.auto.login.internal.request.parameter.configuration.RequestParameterAutoLoginConfiguration"}, property={"type=request.parameter"}, service={AutoLogin.class})
public class RequestParameterAutoLogin
extends BaseAutoLogin {
    private static final Log _log = LogFactoryUtil.getLog(RequestParameterAutoLogin.class);
    @Reference(target="(&(private.auto.login=true)(type=request.parameter))")
    private AutoLogin _autoLogin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    protected String[] doLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.isEnabled(this._portal.getCompanyId(httpServletRequest))) {
            return null;
        }
        return this._autoLogin.login(httpServletRequest, httpServletResponse);
    }

    protected boolean isEnabled(long companyId) {
        RequestParameterAutoLoginConfiguration requestParameterAutoLoginConfiguration = this._getRequestParameterAutoLoginConfiguration(companyId);
        if (requestParameterAutoLoginConfiguration == null) {
            return false;
        }
        return requestParameterAutoLoginConfiguration.enabled();
    }

    private RequestParameterAutoLoginConfiguration _getRequestParameterAutoLoginConfiguration(long companyId) {
        try {
            return (RequestParameterAutoLoginConfiguration)this._configurationProvider.getConfiguration(RequestParameterAutoLoginConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.portal.security.auto.login.request.parameter"));
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)"Unable to get request parameter auto login configuration", (Throwable)configurationException);
            return null;
        }
    }
}

